#include "giveopinionsink.h"

#include "authenticationwindow.h"
#include "giveopinionwindow.h"
#include "plugin.h"


GiveOpinionSink::GiveOpinionSink(const PluginInterface *interface) : PluginAction(interface) {
    image = QImage(":/images/logo.png");
    image = image.scaledToHeight(48, Qt::SmoothTransformation);
}

void GiveOpinionSink::clickAction(QWidget *parentWindow) {
    if(plugin->authenticated) {
        GiveOpinionWindow *win = new GiveOpinionWindow(parentWindow, plugin, GiveOpinionWindow::CreateOpinion);
        win->show();
    } else {
        plugin->checkAuthentication(parentWindow, Plugin::GiveOpinion);
    }
}

void GiveOpinionSink::setPlugin(Plugin *plugin) {
    this->plugin = plugin;
}

QImage GiveOpinionSink::getImage() {
    return image;
}
