#include "editnetwork.h"
#include "ui_editnetwork.h"
#include "plugin.h"
#include "searchuserswindow.h"
#include <QtXml>
#include <QtGui>
#include "trustdialog.h"
#include "htmldelegate.h"
EditNetwork::EditNetwork(QWidget *parent, Plugin *plugin) :
    QMainWindow(parent),
    ui(new Ui::EditNetwork)
{
    this->plugin = plugin;
    ui->setupUi(this);

    model = new QStandardItemModel(this);
    ui->tblNetwork->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    ui->tblNetwork->setProperty("FingerScrollable", true);
    HtmlDelegate *delegate = new HtmlDelegate();
    ui->tblNetwork->setItemDelegateForColumn(0,delegate);
    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(replyFinished(QNetworkReply*)));

    ui->tblNetwork->setModel(model);
    refreshNetwork();
    setAttribute(Qt::WA_Maemo5StackedWindow);
}

EditNetwork::~EditNetwork()
{
    delete ui;
}

void EditNetwork::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void EditNetwork::replyFinished(QNetworkReply* reply) {
    QString data = QString::fromUtf8(reply->readAll()); // use UTF-8 encoding (why doesn't Qt detect this by itself?)
    qDebug() << "\n\n----Returned data---\n\n" << data << "\n\n\n";
    if(requestType == GetNetwork) {
        QDomDocument doc;
        doc.setContent(data);
        QDomElement response = doc.documentElement();
        if(response.isNull()) {
            qDebug("No response found!");
        }
        QDomElement nodes = response.firstChildElement("nodes");
        if(nodes.isNull()) {
            qDebug("No nodes found!");
        }
        QDomElement resource = nodes.firstChildElement("resource");
        model->clear();
        int row = 0;
        while(!resource.isNull()) {
            QDomElement user = resource.firstChildElement("user");
            QDomElement username = user.firstChildElement("username");
            QDomElement userId = user.firstChildElement("id");
            QDomElement score = resource.firstChildElement("score");

            QString convertedScore = QString::number(score.text().toDouble() * 100.0);
            QStandardItem *userItem = new QStandardItem(username.text() + "<br/><span style='font-size: small; color: grey'>" + convertedScore + "</span>");
            QStandardItem *removeItem = new QStandardItem("Remove");

            QVariantHash itemData;
            itemData.insert("userId", userId.text());
            itemData.insert("score", score.text());
            userItem->setData(itemData);
            removeItem->setData(itemData);
            removeItem->setTextAlignment(Qt::AlignRight);

            model->setItem(row,0,userItem);
            model->setItem(row,1,removeItem);

            resource = resource.nextSiblingElement("resource");
            row++;
        }
        ui->tblNetwork->resizeRowsToContents();
    } else if(requestType == UpdateTrust) {
        refreshNetwork();
    } else if(requestType == DeleteTrust) {
        refreshNetwork();
    }
}
void EditNetwork::refreshNetwork() {
    requestType = GetNetwork;
    model->clear();
    //Getting data
    QString dataUrl = plugin->baseUrl + "network/show.xml"; //
    QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + "?" + plugin->generateOAuthData()));
    manager->get(request);
}

void EditNetwork::on_pushButton_clicked()
{
    SearchUsersWindow *search = new SearchUsersWindow(this, plugin);
    search->show();
}

void EditNetwork::on_tblNetwork_clicked(QModelIndex index)
{
    QStandardItem *item = model->itemFromIndex(index);
    QVariantHash itemData = item->data().toHash();
    QString userId = itemData.value("userId").toString();
    double trustScore = itemData.value("score").toDouble();
    if(item->column() == 0) {
        qDebug() << QString::number(trustScore);
        int realScore = (int) (trustScore * 100.0); // convert from 0.1 to 10 (for use in the slider)

        TrustDialog *dialog = new TrustDialog(this, realScore);
        if(dialog->exec() == QDialog::Accepted) {
            QString dataUrl = plugin->baseUrl + "trustnode/update/" + userId + ".xml"; //
            QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + "?" + plugin->generateOAuthData()));
            double scoreAsPercent = ((double)dialog->score) / 100.0;
            QString postdata = "score=" + QString::number(scoreAsPercent);
            requestType = UpdateTrust;
            manager->put(request,postdata.toLatin1());
        }
    } else if(item->column() == 1) {
        QMessageBox *prompt = new QMessageBox(this);
        prompt->setWindowTitle("Remove user?");
        prompt->setText("Are you sure you want to remove this user from your trust network?");
        prompt->setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
        int ret = prompt->exec();
        if(ret == QMessageBox::Ok) {
            QString dataUrl = plugin->baseUrl + "trustnode/remove/" + userId + ".xml"; //
            QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + "?" + plugin->generateOAuthData()));
            requestType = DeleteTrust;
            request.setRawHeader("X-HTTP-Method-Override","DELETE");
            manager->post(request,"");
        }
    }
    ui->tblNetwork->clearSelection(); // mimic the behaviour of Hildon tables (like in the e-mail app)
}
