#include "settingswindow.h"
#include "ui_settingswindow.h"

#include "editnetwork.h"
#include "searchuserswindow.h"
#include "opinionswindow.h"

SettingsWindow::SettingsWindow(QWidget *parent, Plugin *plugin) :
    QMainWindow(parent),
    ui(new Ui::SettingsWindow)
{
    this->plugin = plugin;
    ui->setupUi(this);
    setAttribute(Qt::WA_Maemo5StackedWindow);
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}

void SettingsWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsWindow::on_btnEditOpinions_clicked()
{
    OpinionsWindow *win = new OpinionsWindow(this, plugin);
    win->show();
}

void SettingsWindow::on_btnEditNetwork_clicked()
{
    EditNetwork *win = new EditNetwork(this, plugin);
    win->show();
}

void SettingsWindow::on_btnSearchUsers_clicked()
{
    SearchUsersWindow *win = new SearchUsersWindow(this, plugin);
    win->show();
}
