#include "giveopinionwindow.h"
#include "ui_giveopinionwindow.h"
#include "plugin.h"
#include <QtXml>
#include <QtGui>

// TODO: Check if user already has an opinion about the product. If so, load the data which is already available and update on submit. If not, start blank.

GiveOpinionWindow::GiveOpinionWindow(QWidget *parent, Plugin *plugin, Mode mode) :
    QMainWindow(parent),
    ui(new Ui::GiveOpinionWindow)
{
    this->plugin = plugin;
    ui->setupUi(this);

    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(replyFinished(QNetworkReply*)));

    if(mode == GiveOpinionWindow::CreateOpinion) {
        //Getting data
        requestType = RequestGetOpinion;
        QString dataUrl = plugin->baseUrl + "opinion/show.xml?" +
                          "identifier_type=" + plugin->barcodeType +
                          "&identifier_data=" + plugin->barcodeData; //
        QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + "&" + plugin->generateOAuthData()));
        manager->get(request);
    }
    this->mode = mode;
    setAttribute(Qt::WA_Maemo5StackedWindow);

}

GiveOpinionWindow::~GiveOpinionWindow()
{
    delete ui;
}

// Set the ID of the opinion. Not used for mode == create.
void GiveOpinionWindow::setOpinionId(QString opinionId) {
    this->opinionId = opinionId;
}

void GiveOpinionWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void GiveOpinionWindow::on_btnSubmit_clicked()
{
    //Getting data
    QString dataUrl;
    if(mode == CreateOpinion) {
        qDebug() << "GiveOpinionWindow::on_btnSubmit_clicked(): Mode is create";
        dataUrl = plugin->baseUrl + "opinion/create.xml?"; //
    } else {
        qDebug() << "GiveOpinionWindow::on_btnSubmit_clicked(): Mode is update";
        dataUrl = plugin->baseUrl + "opinion/update/" + opinionId + ".xml?"; //
    }
    QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + plugin->generateOAuthData()));
    double realScore = (double)ui->sldScore->value() / 100.0;
    QString d = "score=" + QString::number(realScore) +
                "&description=" + ui->txtDescription->toPlainText().toUtf8();
    if(mode == CreateOpinion) {
        d.append("&identifier_type=" + plugin->barcodeType +
                   "&identifier_data=" + plugin->barcodeData);
        requestType = RequestCreateOpinion;
        manager->post(request, d.toLatin1());
    } else {
        requestType = RequestUpdateOpinion;
        manager->put(request, d.toLatin1());
    }
}
void GiveOpinionWindow::replyFinished(QNetworkReply* reply) {
    QString data = QString::fromUtf8(reply->readAll()); // use UTF-8 encoding (why doesn't Qt detect this by itself?)
    qDebug() << "\n\n----Returned data---\n\n" << data << "\n\n\n";
    if(requestType == RequestGetOpinion) {
        QDomDocument doc;
        doc.setContent(data);
        QDomElement response = doc.documentElement();
        QDomElement score = response.firstChildElement("score");
        QDomElement description = response.firstChildElement("description");
        QDomElement id = response.firstChildElement("id");
        if(!score.isNull()) { // we recieved an object
            QMessageBox msgBox;
            msgBox.setText("An opinion about this product already exists. Would you like to update this opinion?");
            msgBox.setStandardButtons(QMessageBox::Cancel | QMessageBox::Ok);
            int ret = msgBox.exec();
            if(ret == QMessageBox::Ok) {
                mode = UpdateOpinion;
                int percentScore = (int) (score.text().toDouble() * 100.0);
                ui->sldScore->setValue(percentScore);
                ui->txtDescription->setPlainText(description.text());
                opinionId = id.text();
            } else {
                this->hide();
            }
        }
    } else {
        // TODO: Make this actually check if the opinion was saved.
        // Opinion saved. Hide window.
        this->hide();
    }
}
void GiveOpinionWindow::setScore(int score) {
    ui->txtScore->setText(QString::number(score));
    ui->sldScore->setValue(score);
}
void GiveOpinionWindow::setDescription(QString description) {
    ui->txtDescription->setPlainText(description);
}

void GiveOpinionWindow::on_sldScore_valueChanged(int value)
{
    ui->txtScore->setText(QString::number(value));
}
