#include "getopinionwindow.h"
#include "ui_getopinionwindow.h"
#include "plugin.h"
#include "editnetwork.h"
#include "opinionswindow.h"
#include <QtXml>
#include "htmldelegate.h"

GetOpinionWindow::GetOpinionWindow(QWidget *parent, Plugin *plugin) :
    QMainWindow(parent),
    ui(new Ui::GetOpinionWindow)
{
    this->plugin = plugin;
    ui->setupUi(this);

    ui->menuMenu->setTitle(""); // remove that stupid "Menu" text

    ui->tblOpinions->setProperty("FingerScrollable", true);
    ui->tblOpinions->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    HtmlDelegate *delegate = new HtmlDelegate();
    ui->tblOpinions->setItemDelegateForColumn(0,delegate);
    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(replyFinished(QNetworkReply*)));
    model = new QStandardItemModel(this);
    ui->tblOpinions->setModel(model);

    //Getting data
    QString dataUrl = plugin->baseUrl + "result/show.xml?identifier_type=" + plugin->barcodeType + "&identifier_data=" + plugin->barcodeData; //
    qsrand ( time(0) + 1);
    QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + "&" + plugin->generateOAuthData()));
    manager->get(request);
    svgWidget = new QSvgWidget(this);
    svgWidget->setMinimumSize(100,100);
    svgWidget->setMaximumSize(100,100);
    svgWidget->load(QString(":/icons/emotes/face-monkey.svg"));
    ui->horizontalLayout->addWidget(svgWidget);
}

GetOpinionWindow::~GetOpinionWindow()
{
    delete ui;
}

void GetOpinionWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void GetOpinionWindow::replyFinished(QNetworkReply* reply) {
    QString data = QString::fromUtf8(reply->readAll()); // use UTF-8 encoding (why doesn't Qt detect this by itself?)
    if(reply->error() == QNetworkReply::NoError) {
        qDebug() << "\n\n----Returned data---\n\n" << data << "\n\n\n";
        QDomDocument doc;
        doc.setContent(data);
        QDomElement response = doc.documentElement();
        if(response.isNull()) {
            qDebug("No response found!");
        }
        QDomElement result = response.firstChildElement("result");
        if(response.isNull()) {
            qDebug("No result found!");
        }
        QDomElement score = result.firstChildElement("score");
        if (!score.isNull() ) {
            int scoreAsPercent = (int)(score.text().toDouble() * 100.0);
            ui->lblScore->setText(QString::number(scoreAsPercent));
            // Set the smiley image
            QString imageFile;
            if(score.text().toFloat() > 0.9) {
                imageFile = "face-grin.svg";
            } else if(score.text().toFloat() > 0.8) {
                imageFile = "face-smile-big.svg";
            } else if(score.text().toFloat() > 0.6) {
                imageFile = "face-smile.svg";
            } else if(score.text().toFloat() > 0.4) {
                imageFile = "face-plain.svg";
            } else if(score.text().toFloat() > 0.3) {
                imageFile = "face-sad.svg";
            } else if(score.text().toFloat() > 0.2) {
                imageFile = "face-surprise.svg";
            } else {
                imageFile = "face-crying.svg";
            }
            svgWidget->load(":/icons/emotes/" + imageFile);
        } else {
            qDebug() << "Score not found";
        }
        QDomElement opinions = response.firstChildElement("opinions");
        if(!opinions.isNull()) {
            int row = 0;
            model->clear();
            QDomElement resource = opinions.firstChildElement("resource");
            while(!resource.isNull()) {
                QDomElement opinionScore = resource.firstChildElement("score");
                QDomElement opinionDesc = resource.firstChildElement("description");
                QDomElement opinionTrust = resource.firstChildElement("trust");
                QDomElement opinionUser = resource.firstChildElement("user");
                QDomElement username = opinionUser.firstChildElement("username");
                if(!opinionScore.isNull()) {
                    // Set the table model
                    int realScore = (int)(opinionScore.text().toDouble() * 100.0);
                    int realTrust = (int)(opinionTrust.text().toDouble() * 100.0);
                    QStandardItem *scoreItem = new QStandardItem(QString::number(realScore) + " points");
                    QStandardItem *descItem = new QStandardItem(opinionDesc.text() + "<br/><span style='font-size: small; color: grey'>by " + username.text() + ", trusted with " + QString::number(realTrust) + " points</span>");
                    model->setItem(row,0,descItem);
                    model->setItem(row,1,scoreItem);

                    scoreItem->setTextAlignment(Qt::AlignRight);
                    row++;
                }
                resource = resource.nextSiblingElement("resource");
            }
        }
        ui->tblOpinions->resizeRowsToContents();
        ui->tblOpinions->resizeColumnsToContents();
    } else if(reply->error() == QNetworkReply::ContentNotFoundError) {
        QMessageBox msgBox(QMessageBox::Information, "Not found", "There are no opinions about this product.");
        msgBox.exec();
    } else {
        QMessageBox msgBox(QMessageBox::Critical, "Error", "An error occured, but we have no idea why. Please check the application logs and report the mighty developers.");
        msgBox.exec();
    }
}

void GetOpinionWindow::on_actionEdit_Network_triggered()
{
    EditNetwork *win = new EditNetwork(this, plugin);
    win->show();
}

void GetOpinionWindow::on_actionEdit_Opinions_triggered()
{
    OpinionsWindow *win = new OpinionsWindow(this, plugin);
    win->show();
}

void GetOpinionWindow::on_tblOpinions_clicked(QModelIndex index)
{

    // Add code before this line!
    ui->tblOpinions->clearSelection(); // mimic the behaviour of Hildon tables (like in the e-mail app)
}
