#ifndef GIVEOPINIONWINDOW_H
#define GIVEOPINIONWINDOW_H

#include <QMainWindow>
#include <QtNetwork>

namespace Ui {
    class GiveOpinionWindow;
}
class Plugin;
class GiveOpinionWindow : public QMainWindow {
    Q_OBJECT
public:

    enum Mode {CreateOpinion, UpdateOpinion};
    GiveOpinionWindow(QWidget *parent, Plugin *plugin, Mode mode = GiveOpinionWindow::CreateOpinion);
    ~GiveOpinionWindow();

    void setOpinionId(QString opinionId);
    void setScore(int score);
    void setDescription(QString description);
    enum RequestType {RequestUpdateOpinion, RequestCreateOpinion, RequestGetOpinion};
protected:
    void changeEvent(QEvent *e);

private:
    Ui::GiveOpinionWindow *ui;
    Plugin *plugin;

    QNetworkAccessManager *manager;
    Mode mode;
    QString opinionId;

    RequestType requestType;
private slots:
    void on_sldScore_valueChanged(int value);
    void on_btnSubmit_clicked();
    void replyFinished(QNetworkReply* reply);
};

#endif // GIVEOPINIONWINDOW_H
