#include "authenticationwindow.h"
#include "ui_authenticationwindow.h"
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QDebug>
#include <QDateTime>
#include <QtDBus>
#include "plugin.h"

AuthenticationWindow::AuthenticationWindow(QWidget *parent, Plugin *plugin) :
    QMainWindow(parent),
    ui(new Ui::AuthenticationWindow)
{
    this->plugin = plugin;
    ui->setupUi(this);
    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(replyFinished(QNetworkReply*)));
}

AuthenticationWindow::~AuthenticationWindow()
{
    delete ui;
}

void AuthenticationWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
bool AuthenticationWindow::oAuthRequestToken() {
    QString requestTokenUrl = plugin->baseUrl + "oauth/request_token/";
    qsrand ( time(0) );
    QString data =  "oauth_version=1.0&oauth_nonce=" + QString::number(qrand()) + "&oauth_timestamp=" + getTimestamp() +
                    "&oauth_consumer_key="+ plugin->consumerKey +
                    "&oauth_signature_method=PLAINTEXT&oauth_signature=" + plugin->consumerSecret + "%26";
    QNetworkRequest request = QNetworkRequest(QUrl(requestTokenUrl));
    requestType = AuthenticationWindow::RequestToken;
    manager->post(request, data.toLatin1());
    return true;
}
bool AuthenticationWindow::oAuthAuthorizeToken() {
    QString authorizeUrl = plugin->baseUrl + "oauth/authorize/";
    QString url = authorizeUrl + "?oauth_token=" + requestToken;
    QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request","com.nokia.osso_browser");
    interface->call("open_new_window",url);
    return true;
}
bool AuthenticationWindow::oAuthAccessToken() {
    QString accessTokenUrl = plugin->baseUrl + "oauth/access_token/";
    qsrand ( time(0) );
    QString data = "oauth_version=1.0&oauth_nonce=" + QString::number(qrand()) + "&oauth_timestamp=" + getTimestamp() +
                  "&oauth_consumer_key=" + plugin->consumerKey +
                  "&oauth_token=" + requestToken +
                  "&oauth_signature_method=PLAINTEXT&oauth_signature=" + plugin->consumerSecret + "%26" + requestTokenSecret +
                  "&oauth_verifier=" + ui->txtVerifier->text();
    QNetworkRequest request = QNetworkRequest(QUrl(accessTokenUrl));
    requestType = AuthenticationWindow::AccessToken;
    manager->post(request, data.toLatin1());
    return true;
}
void AuthenticationWindow::replyFinished(QNetworkReply* reply) {
    QString data = QString::fromUtf8(reply->readAll()); // use UTF-8 encoding (why doesn't Qt detect this by itself?)
    qDebug() << "\n\n----Returned data---\n\n" << data << "\n\n\n";
    QList<QString> replyParams = data.split( '&' );
    if(requestType == AuthenticationWindow::RequestToken) {
        bool foundToken = false;
        bool foundSecret = false;
        foreach(QString pairString, replyParams) {
            QList<QString> pair = pairString.split( '=' );
            if(pair.length() > 1) {
                if(pair[0] == "oauth_token_secret") {
                    foundSecret = true;
                    requestTokenSecret = pair[1];
                } else if(pair[0] == "oauth_token") {
                    foundToken = true;
                    requestToken = pair[1];
                }
                if(foundSecret && foundToken) {
                    qDebug() << "Found request token: " << requestToken << " " << requestTokenSecret;
                    oAuthAuthorizeToken();
                }
            }
        }
    }
    if(requestType == AuthenticationWindow::AccessToken) {
        bool foundToken = false;
        bool foundSecret = false;
        foreach(QString pairString, replyParams) {
            QList<QString> pair = pairString.split( '=' );
            if(pair.length() > 1) {
                if(pair[0] == "oauth_token_secret") {
                    accessTokenSecret = pair[1];
                    foundSecret = true;
                } else if(pair[0] == "oauth_token") {
                    accessToken = pair[1];
                    foundToken = true;
                }
            }
        }
        if(foundSecret && foundToken) {
            qDebug() << "Found access token: " << accessToken << " " << accessTokenSecret;
            plugin->settings->setValue("accessToken",accessToken);
            plugin->settings->setValue("accessTokenSecret",accessTokenSecret);
            ui->label->setText("All good! You may close this window now.");
        }
    }
}

QString AuthenticationWindow::getTimestamp() {
    uint time = QDateTime::currentDateTime().toTime_t();
    return QString::number( time );
}

void AuthenticationWindow::on_btnOpenBrowser_clicked()
{
    oAuthRequestToken();
}

void AuthenticationWindow::on_btnVerify_clicked()
{
    oAuthAccessToken();
}
