#ifndef RECENTDIALOG_H
#define RECENTDIALOG_H

#include <QtGui>
#include "common.h"

class MaemoBarcodeWindow;

namespace Ui {
    class RecentDialog;
}

class RecentDialog : public QDialog
{
    Q_OBJECT

public:
    explicit RecentDialog(MaemoBarcodeWindow *parent);
    ~RecentDialog();

    void imageAnalysed(QString barcodeType, QString barcodeData, QImage *im);
    QString selectedBarcodeData() {return selectedBarcodeData_;}
    QString selectedBarcodeType() {return selectedBarcodeType_;}

protected:
    void changeEvent(QEvent *e);

private:
    Ui::RecentDialog *ui;

    QString selectedBarcodeData_;
    QString selectedBarcodeType_;
    QDateTime selectedBarcodeDateTime_;

    QStandardItemModel *tillRollModel;
    MaemoBarcodeWindow *parent;
    QDir barcodeImageFolder;

private slots:
    void on_tblTillRoll_clicked(QModelIndex index);
    void on_actionClear_History_triggered();
    void on_tblTillRoll_customContextMenuRequested(QPoint pos);

    void loadHistory();
    void saveHistory();
    void delItem();
    void saveItem();
};

#endif // RECENTDIALOG_H
