#include "pluginsettings.h"
#include "ui_pluginsettings.h"

#include "plugininterfaces.h"

class SettingsWindow;

#define IMAGE_COL       0
#define NAME_COL        1
#define CHECKBOX_COL    2
#define PRIORITY_COL    3

#include <stdio.h>

PluginSettings::PluginSettings(QList<PluginAction *>pluginActions, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::PluginSettings)
{
    ui->setupUi(this);
    model = new QStandardItemModel(this);

    int Id = 0;
    foreach(PluginAction *action, pluginActions) {

        QString interfaceName(const_cast<PluginInterface *>(action->getInterface())->getName());
        QString actionName(action->getName());
        QString itemString( interfaceName + "\n" + actionName);

        QStandardItem *sinkNameItem = new QStandardItem(itemString);
        QStandardItem *sinkImageItem = new QStandardItem("");

        // and set the two following values depending on the list values
        QStandardItem *sinkCheckboxItem = new QStandardItem("");

        //int pri = action->getPriority();
        bool enabled = action->getEnabled();

        //qDebug() << actionName << pri << enabled << flush;
        qDebug() << actionName << enabled;

        //QStandardItem *sinkPriorityItem = new QStandardItem(QString("%1").arg(pri));

        QVariantHash sinkdata;
        sinkdata.insert("Id", Id);
        idToAction.insert(Id, action);
        idToInterface.insert(Id, const_cast<PluginInterface *>(action->getInterface()));
        //idToPluginArrays.insert(Id, index);

        sinkImageItem->setData(sinkdata);
        sinkNameItem->setData(sinkdata);
        //sinkPriorityItem->setData(sinkdata);
        sinkCheckboxItem->setData(sinkdata);

        sinkNameItem->setEditable(false);
        sinkCheckboxItem->setCheckable(true);
        if(enabled)
            sinkCheckboxItem->setCheckState(Qt::Checked);
        else
            sinkCheckboxItem->setCheckState(Qt::Unchecked);

        sinkImageItem->setIcon(QIcon(QPixmap::fromImage(action->getImage())));

        model->setItem(Id,IMAGE_COL,sinkImageItem);
        model->setItem(Id,NAME_COL,sinkNameItem);
        model->setItem(Id,CHECKBOX_COL,sinkCheckboxItem);
        //model->setItem(Id,PRIORITY_COL,sinkPriorityItem);

        //ui->tblPlugins->setColumnHidden(PRIORITY_COL, true); // we don't want to see the priority column

        // this doesn't seem to work, but ideally we'll have a larger icon/image and formatted text
        // what we have will do for now though
        /*QLabel *imageLabel = new QLabel();
        imageLabel->setAutoFillBackground(true);
        imageLabel->setTextInteractionFlags(Qt::NoTextInteraction);
        imageLabel->setPixmap(QPixmap::fromImage(action->getImage()));
        ui->tblPlugins->setIndexWidget(model->index(Id,0), imageLabel);

        QLabel *textLabel = new QLabel(itemString);
        textLabel->setAutoFillBackground(true);
        textLabel->setTextInteractionFlags(Qt::NoTextInteraction);
        ui->tblPlugins->setIndexWidget(model->index(Id,1), textLabel);*/

        Id++;
    }

    ui->tblPlugins->setSelectionBehavior(QAbstractItemView::SelectRows);
    ui->tblPlugins->setSelectionMode(QAbstractItemView::SingleSelection);

    ui->tblPlugins->setModel(model);
    ui->tblPlugins->setProperty("FingerScrollable", true);

    ui->tblPlugins->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    ui->tblPlugins->resizeRowsToContents();

    // we also need to do a sort here as we will have added the plugins in an order than is not necessarily
    // the same as their priority order

    //model->sort(PRIORITY_COL);

    setAttribute(Qt::WA_Maemo5StackedWindow);
}

PluginSettings::~PluginSettings()
{
    delete ui;
}

void PluginSettings::showEvent(QShowEvent *) {
    // we might consider moving the table population here rather than in the initialisation fn if there were
    // some other function that modified things like plugin priority or enabling
}

void PluginSettings::hideEvent(QHideEvent *) {
    // let's see what the checkbox values are here

    for(int i=0;i<model->rowCount();++i){
        QStandardItem *item = model->item(i,CHECKBOX_COL);
        QVariantHash data = item->data().toHash();
        int Id = data.value("Id").toInt();
        PluginAction* action = idToAction[Id];

        if(item->checkState()==Qt::Checked){
            action->setEnabled(true);
        }else{
            action->setEnabled(false);
        }
    }
}


void PluginSettings::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void PluginSettings::on_tblPlugins_clicked(QModelIndex index)
{

//    if(index.row()==0){
//        ui->btnIncreasePriority->setEnabled(false);
//        ui->btnReducePriority->setEnabled(true);
//    }else if(index.row()==index.model()->rowCount()-1){
//        ui->btnIncreasePriority->setEnabled(true);
//        ui->btnReducePriority->setEnabled(false);
//    }else{
//        ui->btnIncreasePriority->setEnabled(true);
//        ui->btnReducePriority->setEnabled(true);
//    }

    // if this is a second tap, and assuming it's not a tap on the 3rd column (i.e. checkboxes)
    if (oldIndex==index && index.column()!=CHECKBOX_COL){
        QStandardItem *item = model->itemFromIndex(index);
        QVariantHash data = item->data().toHash();
        int Id = data.value("Id").toInt();
        PluginAction* action = idToAction[Id];
        Q_UNUSED(action)
        PluginInterface* plugin = idToInterface[Id];
        if(plugin->hasSettingsWindow()) {
            plugin->getSettingsWindow(this)->show();
        } else {
            QMessageBox *msgBox = new QMessageBox(QMessageBox::Information, "No settings", "This plugin has no settings window.");
            msgBox->exec();
        }
    }else
        oldIndex = index;
}

void PluginSettings::on_btnIncreasePriority_clicked()
{
//    QItemSelectionModel *selection = ui->tblPlugins->selectionModel();
//    QModelIndexList indices = selection->selectedIndexes();
//    QModelIndex index;
//    if (indices.count())
//        index = indices.at(0); // only one can be selected
//    else
//        return; // nothing selected

//    // get the selected item
//    int row = index.row(); // we need to do this as we have to select a specific column
//    QStandardItem *currentitem = model->itemFromIndex(model->index(row,PRIORITY_COL));

//    // get the one that will be swapped with it
//    row--; // subtract one as we're increasing the priority of currentitem
//    if (row<0)
//        return; // some sort of error, we should never reach this point in fact
//    QStandardItem *otheritem = model->itemFromIndex(model->index(row,PRIORITY_COL));

//    // get PluginActions for both items
//    QVariantHash data = currentitem->data().toHash();
//    int Id = data.value("Id").toInt();
//    PluginAction* currentaction = idToAction[Id];

//    data = otheritem->data().toHash();
//    Id = data.value("Id").toInt();
//    PluginAction* otheraction = idToAction[Id];

//    // now swap priorities in the Plugin actions
//    int temp = otheraction->getPriority();
//    otheraction->setPriority(currentaction->getPriority());
//    currentaction->setPriority(temp);

//    // saw priorities in the row data so the table will be correctly sorted
//    temp = otheritem->data(Qt::DisplayRole).toInt();
//    otheritem->setData(currentitem->data(Qt::DisplayRole).toInt(), Qt::DisplayRole);
//    currentitem->setData(temp, Qt::DisplayRole);

//    qDebug() << "Increase priority: Changed" << currentaction->getName() << "to" << currentaction->getPriority();
//    qDebug() << "Increase priority: and" << otheraction->getName() << "to" << otheraction->getPriority();

//    model->sort(PRIORITY_COL);

//    // reset the oldIndex to double taps work correctly
//    indices = selection->selectedIndexes();
//    oldIndex = indices.at(0); // only one can be selected

//    // sort out the buttons
//    if(oldIndex.row()==0){
//        ui->btnIncreasePriority->setEnabled(false);
//        ui->btnReducePriority->setEnabled(true);
//    }else if(oldIndex.row()==oldIndex.model()->rowCount()-1){
//        ui->btnIncreasePriority->setEnabled(true);
//        ui->btnReducePriority->setEnabled(false);
//    }else{
//        ui->btnIncreasePriority->setEnabled(true);
//        ui->btnReducePriority->setEnabled(true);
//    }
}

void PluginSettings::on_btnReducePriority_clicked()
{
//    QItemSelectionModel *selection = ui->tblPlugins->selectionModel();
//    QModelIndexList indices = selection->selectedIndexes();
//    QModelIndex index;
//    if (indices.count())
//        index = indices.at(0); // only one can be selected
//    else
//        return; // nothing selected

//    // get the selected item
//    int row = index.row(); // we need to do this as we have to select a specific column
//    QStandardItem *currentitem = model->itemFromIndex(model->index(row,PRIORITY_COL));
//    qDebug() << "Current item" << model->itemFromIndex(model->index(row,NAME_COL))->data(Qt::DisplayRole);

//    // get the one that will be swapped with it
//    row++; // subtract one as we're increasing the priority of currentitem
//    if (row>model->rowCount()-1)
//        return; // some sort of error, we should never reach this point in fact
//    QStandardItem *otheritem = model->itemFromIndex(model->index(row,PRIORITY_COL));
//    qDebug() << "Other item" << model->itemFromIndex(model->index(row,NAME_COL))->data(Qt::DisplayRole);

//    // get PluginActions for both items
//    QVariantHash data = currentitem->data().toHash();
//    int Id = data.value("Id").toInt();
//    PluginAction* currentaction = idToAction[Id];
//    qDebug() << "Current action" << currentaction->getName();

//    data = otheritem->data().toHash();
//    Id = data.value("Id").toInt();
//    PluginAction* otheraction = idToAction[Id];
//    qDebug() << "Other action" << otheraction->getName();

//    // now swap priorities in the Plugin actions
//    int temp = otheraction->getPriority();
//    otheraction->setPriority(currentaction->getPriority());
//    currentaction->setPriority(temp);

//    // saw priorities in the row data so the table will be correctly sorted
//    temp = otheritem->data(Qt::DisplayRole).toInt();
//    otheritem->setData(currentitem->data(Qt::DisplayRole).toInt(), Qt::DisplayRole);
//    currentitem->setData(temp, Qt::DisplayRole);

//    qDebug() << "Reduce priority: Actions Changed" << currentaction->getName() << "to" << currentaction->getPriority();
//    qDebug() << "Reduce priority: and" << otheraction->getName() << "to" << otheraction->getPriority();

//    model->sort(PRIORITY_COL);

//    // reset the oldIndex to double taps work correctly
//    indices = selection->selectedIndexes();
//    oldIndex = indices.at(0); // only one can be selected

//    // sort out the buttons
//    if(oldIndex.row()==0){
//        ui->btnIncreasePriority->setEnabled(false);
//        ui->btnReducePriority->setEnabled(true);
//    }else if(oldIndex.row()==oldIndex.model()->rowCount()-1){
//        ui->btnIncreasePriority->setEnabled(true);
//        ui->btnReducePriority->setEnabled(false);
//    }else{
//        ui->btnIncreasePriority->setEnabled(true);
//        ui->btnReducePriority->setEnabled(true);
//    }
}

void PluginSettings::on_tblPlugins_doubleClicked(QModelIndex index)
{
    Q_UNUSED(index)
}
