#ifndef DMTXDECODERTHREAD_H
#define DMTXDECODERTHREAD_H

#include <QObject>
#include <QThread>
#include <QWaitCondition>
#include <qmutex.h>
#include <dmtx.h>
#include <cerrno>

typedef struct {
   int codewords;       /* -c, --codewords */
   int edgeMin;         /* -e, --minimum-edge */
   int edgeMax;         /* -E, --maximum-edge */
   int scanGap;         /* -g, --gap */
   int timeoutMS;       /* -m, --milliseconds */
   int newline;         /* -n, --newline */
   int page;            /* -p, --page */
   int squareDevn;      /* -q, --square-deviation */
   int dpi;             /* -r, --resolution */
   int sizeIdxExpected; /* -s, --symbol-size */
   int edgeThresh;      /* -t, --threshold */
   char *xMin;          /* -x, --x-range-min */
   char *xMax;          /* -X, --x-range-max */
   char *yMin;          /* -y, --y-range-min */
   char *yMax;          /* -Y, --y-range-max */
   int correctionsMax;  /* -C, --corrections-max */
   int diagnose;        /* -D, --diagnose */
   int mosaic;          /* -M, --mosaic */
   int stopAfter;       /* -N, --stop-after */
   int pageNumbers;     /* -P, --page-numbers */
   int corners;         /* -R, --corners */
   int shrinkMax;       /* -S, --shrink */
   int shrinkMin;       /* -S, --shrink (if range specified) */
   int unicode;         /* -U, --unicode */
   int verbose;         /* -v, --verbose */
} UserOptions;


class DMTXDecoderThread : public QThread
{
public:
    DMTXDecoderThread();
    ~DMTXDecoderThread();
    void run();
    char *thread_buffer;
    char *thread_output;
    int frame_width;
    int frame_height;
    int frame_fourcc;
    bool isDecoding; // so the caller can see if we are running without blocking
    QMutex wait_mutex; // to allow the caller to block the thread when data is not available
    QWaitCondition thread_run; // as above
    bool hasFoundBarcode; // variable set if the decoder found something

private:
    int libdmtx_analyse_image();
    bool doQuit; // to signal the thread to quit
    UserOptions opt;
    DmtxPassFail SetDecodeOptions(DmtxDecode *dec, DmtxImage *img, UserOptions *opt);
    int ScaleNumberString(char *s, int extent);
    DmtxPassFail StringToInt(int *numberInt, char *numberString, char **terminate);
};

#endif // DMTXDECODERTHREAD_H
