/*
sudokusettingsdialog.h
Project: masudoku
Platform: Fremantle (maemo5) PR1.2
Author: Petri Kultanen pete@petnetti.net
Last Edit: 3.6.2010
*/
#ifndef SUDOKUSETTINGSDIALOG_H
#define SUDOKUSETTINGSDIALOG_H

#include <QDialog>
class SudokuSettings;
class QColor;
class QCheckBox;

/*
To propeply initialize this class for use. call these functions in this order.

SudokuSettingsDialog();
setSettings();
init();

*/
class SudokuSettingsDialog : public QDialog
{
    Q_OBJECT
public:
    explicit SudokuSettingsDialog(QWidget *parent = 0);

public slots:
    void setColor();
	void setPractiseMode();
	void setShowSolveButton();
	void apply();
public:
    void setSettings(SudokuSettings* aSettings) {iSettings = aSettings;}
    void init();
private:
    SudokuSettings* iSettings;
	QColor iBackgroundColor;
	QColor iFontColor;
	QColor iWrongNumberFontColor;
	QColor iGridColor;
	QColor iFullGridColor;	
	bool iPractiseMode;
	bool iShowSolveButton;
	QPushButton* iGridButton;
	QPushButton* iFontButton;
	QPushButton* iBackground;
	QPushButton* iFullGrid;
	QPushButton* iWrongNumberFont;
	QCheckBox* iPractiseCheckBox;
	QCheckBox* iShowSolveButtonCheckBox;
};

#endif // SUDOKUSETTINGSDIALOG_H
