/*
  sudokuselectnumberwidget.cpp
  Project: masudoku
  Platform: Fremantle (maemo5)
  Author: Petri Kultanen pete@petnetti.net
  Last Edit: 15.2.2010
*/
#include "sudokuselectnumberwidget.h"
#include "sudokutable.h"
#include <QPaintEvent>
#include <QPainter>
#include <QMouseEvent>
/*
  default constructor
  */
SudokuSelectNumberWidget::SudokuSelectNumberWidget()
{
    iSettingNumberHints=false;
    iNumberType = ENormalNumbers;
}
/*
  setTable(CSudokuTable)
  This must be called right after construction, and before this clas can be used.
  */
void SudokuSelectNumberWidget::setTable(CSudokuTable *aTable)
{
    iTable = aTable;
}
/*
  mousePressEvent(QMouseEvent)
  Calculate what number player has pressed, and change that number in iTable.
  */
void SudokuSelectNumberWidget::mousePressEvent(QMouseEvent * aEvent)
{
    //Calculate number
    int x = aEvent->pos().x()/(width()/4);
    int y = aEvent->pos().y()/(height()/4);
    if(x==3) {aEvent->ignore();return;}
    int num = (y*3+x)+1;
    //Clear "button" is pressed
    if(num>9 && num<13) num = 0;
    if(num<0 || num>9) {aEvent->ignore();return;}

    //Normal numbers
    if(iNumberType == ENormalNumbers)
    {
        //IF  bool iSettingNumberHints is true then chek if number will fit in table.
        if(num!=0 && iSettingNumberHints && iTable->isNumInAnyDirectionL((y*3+x)+1,iX,iY)) return;
        iTable->setNumL(num,iX,iY);
        emit numberSelected(num);
        repaint();
    }
    else
    {
        //MarkupNumbers
        if(num==0)
        {
            iTable->removeMemoryNumbers(iX,iY);
        }
        else
        {
            //toggle effect
            if(!iTable->isMemoryNumber(num,iX,iY)) iTable->setMemoryNumber(num,iX,iY);
            else iTable->removeMemoryNumber(num,iX,iY);

        }
        iTable->setNumL(0,iX,iY);
        emit numberSelected(num);

        repaint();
    }
}
/*
  setCoordinates(int,int)
  Changes coordinates that mouse press will change.
  Call this every time player clicks new cell in sudokutablewidget
  */
void SudokuSelectNumberWidget::setCoordinates(int aX,int aY)
{
    iX=aX;
    iY=aY;
    repaint();
}
/*
  setSettingsNumberHints(bool)
  if this setting is selected, player can not select such numbers that won't fit in table,
  and they are drawn with black coplor in this widget.
  */
void SudokuSelectNumberWidget::setSettingNumberHints(bool aBool)
{
    iSettingNumberHints = aBool;
}
/*paintEvent(QPaintEvent)
  called by repaint()
  */
void SudokuSelectNumberWidget::paintEvent(QPaintEvent *aEvent)
{
    //There are 4 celss, beause clear button takes one cell row
    //and right most colum wil be left blank.
    // 1 2 3 X
    // 4 5 6 X
    // 7 8 9 X
    //"Clear"X
    // Note X cels wont be drawn.
    int width1 = width();
    int height1 = height();
    //One cell size
    int h1=height1/4;
    int w1=width1/4;
    QPainter painter(this);
    for(int j=0;j<3;j++)
    {
        for(int i=0;i<3;i++)
        {
            QFont serifFont("Times",h1/2,QFont::Bold);
            painter.setFont(serifFont);
            int num = (j*3+i)+1;
            //If number won't fit in cell then draw it with black color.
            if(iTable->isNumInAnyDirectionL(num,iX,iY) && num!=iTable->getNumL(iX,iY) && iSettingNumberHints && iNumberType==ENormalNumbers) painter.setPen(Qt::black);
            else painter.setPen(Qt::white);
            painter.drawText(QRect(i*w1+(h1/4),j*h1,w1,h1),QString::number(num));
        }
    }
    painter.setPen(Qt::white);
    painter.drawText(QRect(0*w1+(h1/4),3*h1,w1*3,h1),"   Clear");
    //Draw outlines
    for(int i=0;i<4;i++)
    {
        painter.drawLine(0,i*h1,width1-(w1),i*h1);
        painter.drawLine(i*w1,0,i*w1,height1-(h1));
    }
    painter.drawLine(0,3*h1,0,4*h1);
    painter.drawLine(3*w1,4*h1,3*w1,3*h1);
    painter.drawLine(0,(4*h1)-1,3*w1,(4*h1)-1);
}
/*
  togle between normal and markup numbers.
  */
void SudokuSelectNumberWidget::setSettingMarkupOrNormalNumbers(NumberTypes aType)
{
    iNumberType = aType;
    repaint();
}
