/*
 * poi.h - Headers for POI representation
 * Copyright (C) 2010 Collabora Ltd
 * @author Cosimo Alfarano <cosimo.alfarano@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTRCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MAP_BUDDY_POI_H
#define MAP_BUDDY_POI_H

#include <glib-object.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define MAP_BUDDY_TYPE_POI     (map_buddy_poi_get_type())
#define MAP_BUDDY_POI(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), \
      MAP_BUDDY_TYPE_POI, MapBuddyPoi))
#define MAP_BUDDY_POI_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),  MAP_BUDDY_TYPE_POI, \
                           MapBuddyPoiClass))
#define MAP_BUDDY_IS_POI(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
      MAP_BUDDY_TYPE_POI))
#define MAP_BUDDY_IS_POI_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),  MAP_BUDDY_TYPE_POI))
#define MAP_BUDDY_POI_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj),  MAP_BUDDY_TYPE_POI, \
                             MapBuddyPoiClass))

typedef struct _MapBuddyPoi MapBuddyPoi;
typedef struct _MapBuddyPoiClass MapBuddyPoiClass;

GType map_buddy_poi_get_type (void);

MapBuddyPoi *map_buddy_poi_new (guint id, const gchar *name, gdouble lat,
    gdouble lon);

void map_buddy_poi_set_feature (MapBuddyPoi *self, const gchar *feat,
    const gchar *feat_type);

const gchar *map_buddy_poi_get_name (MapBuddyPoi *self);
gint map_buddy_poi_get_id (MapBuddyPoi *self);
gint map_buddy_poi_get_srid (MapBuddyPoi *self);
gdouble map_buddy_poi_get_lat (MapBuddyPoi *self);
gdouble map_buddy_poi_get_lon (MapBuddyPoi *self);

const gchar *map_buddy_poi_get_feature (MapBuddyPoi *self);
const gchar *map_buddy_poi_get_feature_type (MapBuddyPoi *self);
ClutterActor *map_buddy_poi_get_icon_small (MapBuddyPoi *self);
ClutterActor *map_buddy_poi_get_icon_big (MapBuddyPoi *self);

void map_buddy_poi_set_tags (MapBuddyPoi *self, GHashTable *tags);
GHashTable *map_buddy_poi_get_tags (MapBuddyPoi *self);
G_END_DECLS

#endif
