--
-- table for MapBuddy 0.4+
-- target dbms: SQLite
--


--
-- setting up a transaction
--
BEGIN;

--
-- Initialize OpenGIS tables
--
--reenable this function when spatial_ref_sys will be fully used.
-- SELECT InitSpatialMetaData();

--
-- creating the MapBuddy OSM POI's table
--
CREATE TABLE osm_point_of_interest (
	"id" INTEGER PRIMARY KEY AUTOINCREMENT,
	"osm_id" INTEGER NOT NULL UNIQUE,
	"feature" TEXT NOT NULL,
	"feature_type" TEXT NOT NULL,
	"name" TEXT NOT NULL,
	"geometry" POINT
);

--
-- Adding the Geometry column to osm_point_of_interest using 4326 SRID for OSM (PostGIS).
--
--reenable this function when spatial_ref_sys will be fully used
--SELECT addGeometryColumn ('osm_point_of_interest', 'geometry', 4326, 'POINT', 2);

--
-- Adding tags table using poi_id as (emulated) foreign key from
-- osm_point_of_interest
--
CREATE TABLE osm_point_of_interest_tag (
	"osm_id" INTEGER NOT NULL
		CONSTRAINT fk_osm_id REFERENCES osm_point_of_interest(osm_id) ON DELETE CASCADE,
	"key" TEXT NOT NULL,
	"value" TEXT NOT NULL,
	PRIMARY KEY ("osm_id", "key")
);

--
-- Foreign key in Sqlite < 3.6.19 are not implemented
-- although they are accepted in the syntax, it ignores them
-- We use Triggers to emulate them as described on:
-- http://www.sqlite.org/cvstrac/wiki?p=ForeignKeyTriggers
--
CREATE TRIGGER fk_insert_osm_id
BEFORE INSERT ON osm_point_of_interest_tag
FOR EACH ROW BEGIN
	SELECT RAISE(ROLLBACK, 'insert on table "osm_point_of_interest_tag" violates foreign key constraint "fk_osm_id"')
	WHERE (
		SELECT osm_id
		FROM osm_point_of_interest
		WHERE osm_id = new.osm_id
	) IS NULL;
END;


CREATE TRIGGER fk_update_osm_id
BEFORE UPDATE ON osm_point_of_interest_tag
FOR EACH ROW BEGIN
	SELECT RAISE(ROLLBACK, 'update on table "osm_point_of_interest_tag" violates foreign key constraint "fk_osm_id"')
	WHERE (
		SELECT osm_id
		FROM osm_point_of_interest
		WHERE osm = NEW.osm_id
	) IS NULL;
END;


--
-- confirming the pending transaction
--
COMMIT;

--
-- all done * job completed *
--

