#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice, random
import time

class SingleSymbolGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties 
        self.step = 0
        self.slots = []
        w = self.reactor.screen.get_width() - 360 - 150*0.6
        h = self.reactor.screen.get_height() - 60 - 150*0.6
        for x in range(0, 5):
            for y in range(0, 5):
                #~ self.slots.append([(((x*2)-1)*(w/10))+190,(((y*2)-1)*(h/10))+40])
                self.slots.append([x*(w/4)+180,y*(h/4)+30])
        # Universal Properties
        self.task = "There's at least one gem that only appears once"
    
    def play(self):
        if self.step == 0:
            self.step = 75
            self.reactor.clearPlayArea()
            choices = range(1,8)
            self.single = False
            if random() > 0.7:
                self.single = int(random()*7)+1
                choices.remove(self.single)
                self.gems = [Gem(self.reactor, choice(choices)) for i in xrange(24)]
                singleGem = Gem(self.reactor, self.single)
                self.gems.insert(choice(range(24)), singleGem)
            else:
                self.gems = [Gem(self.reactor, choice(choices)) for i in xrange(11)]
                for i in range(1,8):
                    self.gems.insert(choice(range(0,len(self.gems))), Gem(self.reactor, i))
                    self.gems.insert(choice(range(0,len(self.gems))), Gem(self.reactor, i))
            for i in range(0, len(self.slots)):
                #~ r = self.gems[i].gem.get_rect()
                #~ r.center = self.slots[i]
                self.reactor.screen.blit(self.gems[i].gem, self.slots[i])
        else:
            self.step = self.step - 1
            
    def evaluate(self, player):
        if self.single:
            self.winMessage = "Well spotted!"
            self.loseMessage = "You missed it."
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.winMessage = "You win!"
            self.loseMessage = "You're wrong"
            if player == 1: return 2
            if player == 2: return 1
            
class Gem(object):
    def __init__(self, reactor, type):
        self.reactor = reactor
        self.type = type
        self.gem, self.gemRect = self.reactor.load_image(
                                 'gem0' + str(self.type) + '.png', -1)
        #~ self.gem = pygame.transform.rotozoom(self.gem, choice(range(0,359)), 0.5)
        self.gem = pygame.transform.rotozoom(self.gem, 0, 0.6)
        #~ self.gem = pygame.transform.rotate(
                                #~ self.gem, choice(range(0,359)))
        #~ self.gem = pygame.transform.scale(
                           #~ self.gem, (90, 90))
        
        
        
        
        
        
        
        
