#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice, sample, random
import time

class SadSmileyGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties
        self.happy, r = self.reactor.load_image('s_happy.png', -1)
        self.sad, r = self.reactor.load_image('s_sad.png', -1)
        self.slots = []
        w = self.reactor.screen.get_width() - 360 - 80
        h = self.reactor.screen.get_height() - 60 - 80
        for x in range(0, 5):
            for y in range(0, 5):
                self.slots.append([x*(w/4)+190,y*(h/4)+40])
        self.step = 0
        # Universal Properties
        self.task = "Everyone is happy"
    
    def play(self):
        if self.step == 0:
            self.step = 45
            self.reactor.clearPlayArea()
            choices = sample(self.slots, 12)
            sad = (random() > 0.6)
            self.isSad = sad
            for slot in choices:
                if sad:
                    self.reactor.screen.blit(pygame.transform.rotozoom(
                                self.sad, choice(range(0,359)), 0.8), slot)
                    sad = False
                else:
                    self.reactor.screen.blit(pygame.transform.rotozoom(
                                self.happy, choice(range(0,359)), 0.8), slot)
            
        else:
            self.step = self.step - 1
    
    def evaluate(self, player):
        if not self.isSad:
            self.winMessage = "That's right!"
            self.loseMessage = "You lose!"
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.winMessage = "You win!"
            self.loseMessage = "Not everyone!"
            if player == 1: return 2
            if player == 2: return 1
        
        
        
        
        
        
        
        
        
