#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice, sample, random
import time
import os

class FlagGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties
        self.happy, r = self.reactor.load_image('s_happy.png', -1)
        self.sad, r = self.reactor.load_image('s_sad.png', -1)
        self.flags = []
        for file_path in os.listdir(os.path.join("data", "flags")):
            self.flags.append(file_path)
        self.step = 0
        # Universal Properties
        self.task = "The flag matches the country"
    
    def play(self):
        if self.step == 0:
            self.step = 45
            self.reactor.clearPlayArea()
            selection = sample(self.flags, 4)
            self.flag = choice(selection)
            self.draw_flag(self.flag)
            self.realTitle = os.path.splitext(self.flag)[0]
            self.title = self.realTitle
            if random() > 0.3:
                selection.remove(self.flag)
                f = choice(selection)
                self.title = os.path.splitext(f)[0]
            self.draw_name(self.title)
        else:
            self.step = self.step - 1
    
    def draw_flag(self, flag):
        textSize = 30
        w = self.reactor.screen.get_width()
        h = self.reactor.screen.get_height()
        self.image, r = self.reactor.load_image(os.path.join('flags', self.flag))
        image = pygame.transform.rotozoom(
                                self.image, -90, 0.2)
        pw = image.get_width()
        ph = image.get_height()
        bg = Rect(195+textSize, 35, pw+10, ph+10)
        pygame.draw.rect(self.reactor.screen, (100,100,100), bg)
        self.reactor.screen.blit(image, (200+textSize,40))
        image = pygame.transform.rotozoom(
                            image, 180, 1)
        bg = Rect(w-205-textSize-pw, h-45-ph, pw+10, ph+10)
        pygame.draw.rect(self.reactor.screen, (100,100,100), bg)
        self.reactor.screen.blit(image, (w-200-textSize-pw,h-40-ph))
    
    def draw_name(self, name):
        vCenter = self.reactor.screen.get_height()/2
        h = self.reactor.screen.get_height()
        vTot = h-60
        lCenter = (180, vCenter)
        w = self.reactor.screen.get_width()
        rCenter = (w-180, vCenter)
        textSize = 30
        self.reactor.drawText(name, lCenter, vTot, "left", size=textSize)
        self.reactor.drawText(name, rCenter, vTot, "right", size=textSize)
    
    def evaluate(self, player):
        equal = (self.realTitle == self.title)
        if not equal:
            if (self.realTitle == "Chad") or (self.realTitle == "Romania"):
                if (self.title == "Romania") or (self.title == "Chad"):
                    equal = True
        if equal:
            self.winMessage = "You name it!"
            self.loseMessage = "You lose!"
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.reactor.clearPlayArea()
            self.draw_flag(self.flag)
            self.draw_name(self.realTitle)
            self.winMessage = "You win!"
            self.loseMessage = "You're wrong."
            if player == 1: return 2
            if player == 2: return 1
        
        
        
        
        
        
        
        
        
