#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice, shuffle
import time
import textwrap
import sys
import os

#something for maemo, taken from twaeltis's pypackager wiki
os.environ["SDL_VIDEO_X11_WMCLASS"]="maemoreactor"

from minigames import (crashgame, colorgame, calcgame,
                      sizegame, colormatchgame, sadsmileygame,
                      isprimegame, countdowngame, minsymbolsgame,
                      singlesymbolgame, alphabetgame, flaggame)

class MaemoReactor(object):
    '''Main program'''
    def __init__(self):
        pygame.init()
        pygame.display.set_caption('Maemo Reactor')
        try:
            if sys.argv[1] == "f":
                #~ self.display = pygame.display.set_mode((800,480),
                    #~ pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE)
                self.screen = pygame.display.set_mode((800,480),
                    pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE)
            else:
                #~ self.display = pygame.display.set_mode((800,480))
                self.screen = pygame.display.set_mode((800,480))
        except:
            #~ self.display = pygame.display.set_mode((800,480), pygame.RESIZABLE)
            self.screen = pygame.display.set_mode((800,480), pygame.RESIZABLE)
        #~ self.screen = pygame.Surface((800, 480))
        #~ self.screen.fill((0,0,0))
        h = self.screen.get_height()
        w = self.screen.get_width()
        self.banner, r = self.load_image("main.png", -1)
        self.banner = pygame.transform.rotozoom(self.banner, 90,0.5)
        #~ self.starfield = Starfield(self, 150,0,w-150-150-100-100,h, 200, "up")
        # buttons for both players
        self.button1 = Button(self, 0, 0, 150, h, "left")
        self.button2 = Button(self, w-150, 0, 150, h, "right")
        # option buttons and sliders for before the game
        self.showIntrosB = Button(self, w-160-100-90, 0, 90, h, "right")
        self.showIntrosB.setCaption("Show tasks before games")
        self.showIntrosB.setColor((0, 71, 171))
        self.showIntrosB.toggle()
        ypos = -(4000 - self.screen.get_height())
        self.numberOfGamesS = Slider(self, w-160-90, ypos+200, 90, 4000, "right")
        self.numberOfGamesS.setCaption("Number of games")
        self.numberOfGamesS.setColor((0, 71, 171))
        # every area covers half the screen
        self.area1 = Rect(0, 0, w/2, h)
        self.area2 = Rect(w/2, 0, w/2, h)
        # score counter
        self.lastEvent = False
        self.loop()
        pygame.quit()
    
    def getMiniGames(self, number):
        '''returns a list with games evenly distributed'''
        games=["ColorGame", "CrashGame", "CalcGame",
               "SizeGame", "ColorMatchGame", "SadSmileyGame",
               "IsPrimeGame", "CountdownGame", "MinSymbolsGame",
               "SingleSymbolGame", "AlphabetGame", "FlagGame"]
        game = choice(games)
        l = []
        counter = 0
        done = False
        while not done:
            shuffle(games)
            for i in games:
                l.append(self.getGameWithName(i))
                counter += 1
                if counter == number:
                    done = True
                    break
        return l
    
    def getGameWithName(self, game):
        '''returns a new minigame with the given name'''
        #~ return flaggame.FlagGame(self)
        if game == "ColorGame":
            return colorgame.ColorGame(self)
        if game == "CrashGame":
            return crashgame.CrashGame(self)
        if game == "CalcGame":
            return calcgame.CalcGame(self)
        if game == "SizeGame":
            return sizegame.SizeGame(self)
        if game == "ColorMatchGame":
            return colormatchgame.ColorMatchGame(self)
        if game == "SadSmileyGame":
            return sadsmileygame.SadSmileyGame(self)
        if game == "IsPrimeGame":
            return isprimegame.IsPrimeGame(self)
        if game == "CountdownGame":
            return countdowngame.CountdownGame(self)
        if game == "MinSymbolsGame":
            return minsymbolsgame.MinSymbolsGame(self)
        if game == "SingleSymbolGame":
            return singlesymbolgame.SingleSymbolGame(self)
        if game == "AlphabetGame":
            return alphabetgame.AlphabetGame(self)
        if game == "FlagGame":
            return flaggame.FlagGame(self)

    def loop(self):
        '''main loop'''
        clock = pygame.time.Clock()
        exitGame = False
        # main loop
        while not exitGame:
            # greeting phase
            self.greeting = True
            self.ready1 = False
            self.ready2 = False
            self.playing = False
            self.button1.setColor((0, 71, 171))
            self.button2.setColor((0, 71, 171))
            #~ self.button2.setColor((100,100,100))
            self.button1.caption = False
            self.button2.caption = False
            while not (self.ready1 and self.ready2):
                exitGame = self.handleEvents()
                if exitGame == True: break
                self.clearPlayArea()
                hc = self.screen.get_height()/2
                self.screen.blit(self.banner, (160,hc-(self.banner.get_height()/2)))
                self.drawText("MaemoReactor", (400, hc),
                              self.screen.get_height()-40, "right", color = (255,255,255), size=40)
                self.showIntrosB.draw()
                #~ self.starfield.update()
                self.numberOfGamesS.draw()
                self.numberOfGamesS.slide()
                self.button1.draw()
                self.button2.draw()
                if not self.ready1:
                    self.button1.glow()
                if not self.ready2:
                    self.button2.glow()
                #~ self.screen = pygame.transform.rotate(self.screen, -90)
                #~ self.display.blit(self.screen, (0,0))
                pygame.display.flip()
                clock.tick(30)
                #~ exit()
            if exitGame: break
            # playing phase
            games = self.getMiniGames(self.numberOfGamesS.value)
            self.greeting = False
            self.points1 = 0
            self.points2 = 0
            returnToMenu = False
            for g in games:
                if returnToMenu: break
                self.clearPlayArea()
                self.g = g
                self.button1.setColor((0, 71, 171))
                self.button2.setColor((0, 71, 171))
                self.button1.caption = False
                self.button2.caption = False
                # maybe show an intro first
                if self.showIntrosB.toggled:
                    self.intro(self.g.task)
                self.button1.setCaption(self.g.task, (255,255,255), 40)
                self.button2.setCaption(self.g.task, (255,255,255), 40)
                self.button1.draw()
                self.button2.draw()
                self.clearPlayArea()
                endRound = False
                self.discardEvents()
                self.playing = True
                # action phase where stuff happens on screen
                while not endRound:
                    self.g.play()
                    self.drawScore()
                    status = self.handleEvents()
                    if (status == 1) or (status == 2):
                        self.playing = False
                        if self.lastEvent:
                            status = self.handleEvents()
                        if status == 1:
                            self.button1.setColor((0,255,0))
                            self.button1.setCaption(
                                         self.g.winMessage, (0,0,0), 60)
                            self.button2.setColor((255,0,0))
                            self.button2.setCaption(
                                         self.g.loseMessage, (0,0,0), 60)
                            self.points1 = self.points1 + 1
                        if status == 2:
                            self.button2.setColor((0,255,0))
                            self.button2.setCaption(
                                         self.g.winMessage, (0,0,0), 60)
                            self.button1.setColor((255,0,0))
                            self.button1.setCaption(
                                         self.g.loseMessage, (0,0,0), 60)
                            self.points2 = self.points2 + 1
                        self.button1.draw()
                        self.button2.draw()
                        #~ self.display.blit(self.screen, (0,0))
                        pygame.display.flip()
                        break
                    elif status == "return":
                        returnToMenu = True
                        break
                    else:
                        self.button1.draw()
                        self.button2.draw()
                    #~ self.display.blit(self.screen, (0,0))
                    pygame.display.flip()
                    clock.tick(30)
                    if exitGame: break
                # Pause between games
                for i in range(0,60):
                    clock.tick(30)
            self.clearPlayArea()
            self.finalizeGame()
    
    def intro(self, text):
        '''displays a Main Text with the rules of the next minigame'''
        self.drawMainText(text)
        self.button1.draw()
        self.button2.draw()
        self.drawScore()
        line = Rect(self.screen.get_width()/2-2, 0,
                    4, self.screen.get_height())
        pygame.draw.rect(self.screen, (255,255,255), line)
        #~ self.display.blit(self.screen, (0,0))
        pygame.display.flip()
        clock = pygame.time.Clock()
        for i in range(0,30):
            status = self.handleEvents()
            clock.tick(10)
            
    def finalizeGame(self):
        '''at the end of a game, display score and declare winner'''
        if self.points1 > self.points2:
            self.button1.setColor((0,255,0))
            self.button1.setCaption(
                         "You're the winner!", (0,0,0), 60)
            self.button2.setColor((255,0,0))
            self.button2.setCaption(
                         "You lost the game :'(", (0,0,0), 60)
            text = "Player 1 wins " + str(self.points1) + ":" + str(self.points2)
        elif self.points2 > self.points1:
            self.button2.setColor((0,255,0))
            self.button2.setCaption(
                         "You're the winner!", (0,0,0), 60)
            self.button1.setColor((255,0,0))
            self.button1.setCaption(
                         "Better luck next time", (0,0,0), 60)
            text = "Player 2 wins " + str(self.points2) + ":" + str(self.points1)
        else:
            self.button2.setColor((255,165,0))
            self.button2.setCaption(
                         "You're on par", (0,0,0), 60)
            self.button1.setColor((255,165,0))
            self.button1.setCaption(
                         "You're on par", (0,0,0), 60)
            text = "You played a draw with a score of " + str(self.points1)
        line = Rect(self.screen.get_width()/2-2, 0,
                    4, self.screen.get_height())
        pygame.draw.rect(self.screen, (255,255,255), line)
        self.drawMainText(text)
        self.button1.draw()
        self.button2.draw()
        #~ self.display.blit(self.screen, (0,0))
        pygame.display.flip()
        clock = pygame.time.Clock()
        for i in range(0,80):
            status = self.handleEvents()
            clock.tick(10)
    
    def drawMainText(self, text, color=None, single=None):
        '''draws big text into the playing'''
        vCenter = self.screen.get_height()/2
        vTot = self.screen.get_height()-40
        hHalf = self.screen.get_width()/2
        lCenter = ((((hHalf)-150)/2)+150, vCenter)
        rCenter = ((hHalf)+(hHalf-150)/2, vCenter)
        if not single:
            self.drawText(text, lCenter, vTot, "left", color)
            self.drawText(text, rCenter, vTot, "right", color)
        elif single == 1:
            self.drawText(text, lCenter, vTot, "left", color)
        elif single == 2:
            self.drawText(text, rCenter, vTot, "right", color)
        
    
    def clearPlayArea(self):
        '''blanks the screen'''
        self.screen.fill((0,0,0))
    
    def drawScore(self):
        '''draws the small score numbers into the corners'''
        textFont = pygame.font.Font(None, 40)
        text = textFont.render(str(self.points1), 1, (200,200,200))
        self.screen.blit(text, (165, 5))
        text = textFont.render(str(self.points2), 1, (200,200,200))
        self.screen.blit(text, (self.screen.get_width()-185, 5))
    
    def drawText(self, text, center, width, orientation=None,
                 color=None, size=None):
        '''prints multiline text as a centered block'''
        if not orientation:
            orientation = "right"
        if not color: color = (200,200,200)
        if not size: size = 70
        gap = int(size/10)
        textFont = pygame.font.Font(None, size)
        wordsToWrite = text.rstrip().split(" ")
        currLine = ""
        numLines = 0
        maxWidthFound = 0
        lines = []
        # split text into chunks that fit on a line
        for word in wordsToWrite:
            if ((textFont.size(currLine + " " + word))[0] > width):
                if (textFont.size(currLine))[0] > maxWidthFound:
                    maxWidthFound = (textFont.size(currLine))[0]
                lines.append (textFont.render(
                              currLine.rstrip().lstrip(), 1, color))
                currLine = ""
                numLines = numLines + 1
            currLine = currLine + " " + word
        if currLine != "":
            lines.append (textFont.render(
                          currLine.rstrip().lstrip(), 1, color))
            currLine = ""
            numLines = numLines + 1
        #~ self.image = pygame.Surface((maxWidthFound + gap, 
                     #~ numLines * textFont.get_height() + gap))
        # blit the possibly rotated, line by line
        offset = 0
        numberOfLines = len(lines)
        if orientation == "left": degrees = -90
        if orientation == "right": degrees = 90
        if orientation == "down": degrees = 0
        if orientation == "up": degrees = 180
        for lineNum in range(numLines):
            text = lines[lineNum]
            text = pygame.transform.rotate(text, degrees)
            if orientation == "left":
                textpos = text.get_rect(centerx=center[0]+(
                            ((size+gap)*(numberOfLines-1))/2)-offset,
                            centery=center[1])
            if orientation == "right":
                textpos = text.get_rect(centerx=center[0]-(
                            ((size+gap)*(numberOfLines-1))/2)+offset,
                            centery=center[1])
            if orientation == "down":
                textpos = text.get_rect(centerx=center[0],
                            centery=center[1]-(
                            ((size+gap)*(numberOfLines-1))/2)+offset)
            if orientation == "up":
                textpos = text.get_rect(centerx=center[0],
                            centery=center[1]+(
                            ((size+gap)*(numberOfLines-1))/2)-offset)    
            self.screen.blit(text, textpos)
            offset = offset + size + gap
    
    def load_image(self, name, colorkey=None):
        '''loads images from the data directory'''
        fullname = os.path.join('data', name)
        try:
            image = pygame.image.load(fullname)
        except pygame.error, message:
            print 'Cannot load image:', name
            raise SystemExit, message
        image = image.convert()
        if colorkey is not None:
            if colorkey is -1:
                colorkey = image.get_at((0,0))
            image.set_colorkey(colorkey, RLEACCEL)
        return image, image.get_rect()
    
    def discardEvents(self):
        '''empties the event queue discarding all events in it'''
        for event in pygame.event.get():
            pass
    
    def adjustSizesToScreen(self, size):
        '''resizes and moves stuff to fit new screen size'''
        self.screen = pygame.display.set_mode(size, pygame.RESIZABLE)
        self.button1.height = self.button2.height = self.showIntrosB.height = size[1]
        self.button2.left = size[0]-150
        self.area1 = Rect(0, 0, size[0]/2, size[1])
        self.area2 = Rect(size[0]/2, 0, size[0]/2, size[1])
        w = self.screen.get_width()
        self.showIntrosB.left = w-160-100-90
        ypos = -(4000 - self.screen.get_height())
        self.numberOfGamesS.left = w-160-90
        self.numberOfGamesS.top = ypos+200
    
    def handleEvents(self):
        for event in pygame.event.get():
            if event.type == QUIT:
                exit(0)
            elif event.type == VIDEORESIZE:
                self.adjustSizesToScreen(event.size)
            elif event.type == KEYDOWN:
                if (event.key == K_ESCAPE) or (event.key == K_q):
                    exit(0)
                    #~ return True
                if event.key == K_r:
                    if self.playing:
                        return "return"
            elif event.type == MOUSEBUTTONUP:
                self.numberOfGamesS.sliding = False
            elif event.type == MOUSEBUTTONDOWN:
                if self.greeting:
                    x, y = pygame.mouse.get_pos()
                    if self.button1.collidepoint(x, y):
                        self.ready1 = True
                        self.button1.setColor((0,255,0))
                        self.button1.draw()
                    elif self.button2.collidepoint(x, y):
                        self.ready2 = True
                        self.button2.setColor((0,255,0))
                        self.button2.draw()
                    elif self.showIntrosB.collidepoint(x, y):
                        self.showIntrosB.toggle()
                    elif self.numberOfGamesS.collidepoint(x, y):
                        self.numberOfGamesS.toggleSlide((x,y))
                elif self.playing:
                    x, y = pygame.mouse.get_pos()
                    if self.area1.collidepoint(x, y):
                        return self.g.evaluate(1)
                    elif self.area2.collidepoint(x, y):
                        return self.g.evaluate(2)
                else:
                    pass
class Button(Rect):
    def __init__(self, reactor, x, y, w, h, orientation, color=None):
        Rect.__init__(self, x, y, w, h)
        self.center = (self.left+self.width/2, self.top+self.height/2)
        self.reactor = reactor
        self.orientation = orientation
        if not color: self.color = (0, 71, 171)
        else: self.color = color
        self.caption = False
        self.textSize = 40
        self.textColor = (255,255,255)
        self.toggled = False
        self.glowing = True
        self.origColor = self.color
        self.v1 = 0
        self.v2 = 0
        self.v3 = 0
    
    def toggle(self):
        if self.toggled:
            self.toggled = False
            self.textColor = (255,255,255)
        else:
            self.toggled = True
            self.textColor = (0,255,0)
    
    def setColor(self, color):
        self.color = color
        
    def setCaption(self, text, textColor=None, textSize=None):
        self.caption = text
        if textColor: self.textColor = textColor
        if textSize: self.textSize = textSize
    
    def draw(self):
        pygame.draw.rect(self.reactor.screen, self.color, self)
        if self.caption:
            self.reactor.drawText(self.caption, self.center,
                                  self.height-40, self.orientation,
                                  self.textColor, self.textSize)
    
    def glow(self):
        diff = 0
        for i in range(0,3):
            diff += self.origColor[i]-self.color[i]
        if self.glowing == True:
            if diff > 60:
                self.glowing = False
            else:
                c1 = self.color[1]-3
                c2 = self.color[2]-3
                self.color = (self.color[0],c1,c2)
        if self.glowing == False:
            if diff < -60:
                self.glowing = True
            else:
                c1 = self.color[1]+3
                c2 = self.color[2]+3
                self.color = (self.color[0],c1,c2)
                #~ self.color = [i + 2 for i in self.color]

class Slider(Button):
    def __init__(self, reactor, x, y, w, h, orientation, color=None):
        Button.__init__(self, reactor, x, y, w, h, orientation, color)
        self.value = 10
        self.pos = 0
        self.sliding = False
        self.setCaption("lol")
        
    def toggleSlide(self, coords):
        if self.sliding:
            self.sliding = False
        else:
            self.sliding = True
        if (self.orientation == "right") or (self.orientation == "left"):
            self.pos = coords[1]-self.top
        if (self.orientation == "up") or (self.orientation == "down"):
            self.pos = coords[0]-self.left
    
    def slide(self):
        if self.sliding:
            coords = pygame.mouse.get_pos()
            if (self.orientation == "right") or (self.orientation == "left"):
                newTop = coords[1]-self.pos
                if newTop > 0:
                    self.top = 0
                elif newTop < self.reactor.screen.get_height()-self.height:
                    self.top = self.reactor.screen.get_height()-self.height
                else:
                    self.top = coords[1]-self.pos
                    self.value = (self.bottom-self.reactor.screen.get_height()) / 20
            if (self.orientation == "up") or (self.orientation == "down"):
                self.left = coords[0]-self.pos
    
    def draw(self):
        pygame.draw.rect(self.reactor.screen, self.color, self)
        h = self.reactor.screen.get_height()
        center = (self.left+(self.width/2-15), h/2)
        if not self.caption: string = str(self.value)
        else: string = self.caption + ": " + str(self.value)
        self.reactor.drawText(string, center,
                              h-40, self.orientation,
                              self.textColor, self.textSize)
        line = Rect(self.left+self.width-20, self.top+20,
                    5, self.height-40)
        pygame.draw.rect(self.reactor.screen, (255,255,255), line)
        for i in range (20,self.height-20, (self.height-40)/19+1):
            mark = Rect(self.left + self.width-35, self.top+i,
                        15, 5)
            pygame.draw.rect(self.reactor.screen, (255,255,255), mark)

class Starfield(object):
    def __init__(self, reactor, x, y, w, h, numberOfStars, direction):
        self.reactor = reactor
        self.x = x
        self.y = y
        self.w = w
        self.h = h
        self.direction = direction
        self.stars = []
        for n in range(0,numberOfStars):
            star = [choice(xrange(w))+x,choice(xrange(h))+y,choice(range(2,5))]
            self.stars.append(star)
    
    def update(self):
        for s in self.stars:
            if self.direction == "up":
                newPos = s[1]+s[2]
                if newPos < self.y:
                    s[1] = self.y+self.h
                else:
                    s[1] = s[1]-s[2]
            if self.direction == "down":
                newPos = s[1]-s[2]
                if newPos > self.y+self.h:
                    s[1] = self.y
                else:
                    s[1] = s[1]+s[2]
            if self.direction == "left":
                newPos = s[0]-s[2]
                if newPos < self.x:
                    s[0] = self.x+self.w
                else:
                    s[0] = s[0]-s[2]
            if self.direction == "right":
                newPos = s[0]+s[2]
                if newPos > self.x+self.w:
                    s[0] = self.x
                else:
                    s[0] = s[0]+s[2]
            star = Rect(s[0], s[1],
                    s[2], s[2])
            pygame.draw.rect(self.reactor.screen, (255,255,255), star)

# Start the game
MaemoReactor()











