
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  tool_new_(Gtk::Stock::NEW),
  tool_open_(Gtk::Stock::OPEN),
  tool_save_(Gtk::Stock::SAVE),
  tool_close_(Gtk::Stock::CLOSE)
{
  set_title("Toolbar Example");

  // Create Combobox on tool item.
  Gtk::ComboBoxText* combo = Gtk::manage(new Gtk::ComboBoxText);
  combo->append_text("Entry 1");
  combo->append_text("Entry 2");
  combo->append_text("Entry 3");
  combo->set_active(1);
  tool_combo_.add(*combo);
  tool_combo_.set_expand();
    
  // Add toolbar items to toolbar.
  toolbar_.append(tool_new_);
  toolbar_.append(tool_separator_);
  toolbar_.append(tool_open_);
  toolbar_.append(tool_save_);
  toolbar_.append(tool_combo_);
  toolbar_.append(tool_close_);
  
  // Add toolbar.
  add_toolbar(toolbar_);
  toolbar_.show_all(); //Show the toolbar and all its child widgets.

  // Attach the callback functions to the activate signal.
  tool_close_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_item_close));
  
  // Make all child widgets visible
  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_item_close()
{
  hide();
}

