
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow() :
  button1_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "1"),
  button2_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "2"),
  button3_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "3"),
  button4_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "4"),
  button5_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "5"),
  button6_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "6"),
  button7_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "7"),
  button8_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "8"),
  button9_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "9"),
  button10_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "10")
{
  set_title("Hildon::PannableArea Example");

  box_.add(button1_);
  box_.add(button2_);
  box_.add(button3_);
  box_.add(button4_);
  box_.add(button5_);
  box_.add(button6_);
  box_.add(button7_);
  box_.add(button8_);
  box_.add(button9_);
  box_.add(button10_);

  area_.add(box_);
  area_.set_property("mov-mode", Hildon::MOVEMENT_MODE_HORIZ);
  add(area_);

  button1_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  button2_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  button3_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  button4_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  button5_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  button6_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  button7_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  button8_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  button9_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  button10_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_clicked()
{
  std::cout << "Button clicked." << std::endl;
}

