
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  item_others_("Others"),
  item_radio1_(group_, "Radio1"),
  item_radio2_(group_, "Radio2"),  
  item_check_("Check"),
  item_close_("Close")
{
  set_title("Menu Example");

  // Add menu items to right menus.
  main_.append(item_others_);
  sub_others_.append(item_radio1_);
  sub_others_.append(item_radio2_);
  sub_others_.append(item_separator_);
  sub_others_.append(item_check_);
  main_.append(item_close_);
 
  // Add others submenu to the "Others" item.
  item_others_.set_submenu(sub_others_);
  main_.show_all_children(); //Show the main menu and all its child widgets.
  set_main_menu(main_);
  
  // Attach the callback functions to the activate signal.
  item_radio1_.signal_toggled().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_menu_radio1));
  item_radio2_.signal_toggled().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_menu_radio2));
  item_check_.signal_toggled().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_menu_check));
  item_close_.signal_activate().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_menu_close));
  
  // Make all child widgets visible:
  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_menu_radio1()
{
  std::cout << "Menu radioitem1 toggled. Current state=" <<
    item_radio1_.get_active() << std::endl;
}

void ExampleWindow::on_menu_radio2()
{
  std::cout << "Menu radioitem2 toggled. Current state=" <<
    item_radio2_.get_active() << std::endl;
}

void ExampleWindow::on_menu_check()
{
  std::cout << "Menu chickitem toggled. Current state=" <<
    item_check_.get_active() << std::endl;
}

void ExampleWindow::on_menu_close()
{
  hide();
}

