
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <hildonmm/banner.h>

ExampleWindow::ExampleWindow() 
{
  signal_key_press_event().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_key_pressed));

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
  
}

bool ExampleWindow::on_key_pressed(GdkEventKey* event)
{
  if(!event)
    return false;

  switch (event->keyval)
  {
    case GDK_Up:
      Hildon::Banner::show_information(*this, "Key Up");
      break;
    case GDK_Down:
      Hildon::Banner::show_information(*this, "Key Down");
      break;
    case GDK_Left:
      Hildon::Banner::show_information(*this, "Key Left");
      break;
    case GDK_Right:
      Hildon::Banner::show_information(*this, "Key Right");
      break;
    case GDK_Return:
      Hildon::Banner::show_information(*this, "Key Select");
      break;
    case GDK_Escape:
      Hildon::Banner::show_information(*this, "Key Cancel");
      break;
    case GDK_F4:
      Hildon::Banner::show_information(*this, "Open menu");
      break;
    case GDK_F5:
      Hildon::Banner::show_information(*this, "Show Home");
      break;
    case GDK_F6:
      Hildon::Banner::show_information(*this, "Full screen");
      break;
    case GDK_F7:
      Hildon::Banner::show_information(*this, "Increase");
      break;
    case GDK_F8:
      Hildon::Banner::show_information(*this, "Decrease");
      break;
    default:
      Hildon::Banner::show_information(*this, "Other key");
  }
  
  // Returning true would stop the event now.
  return false;
}
