
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <hildon-fmmm/file-chooser-dialog.h>
#include <hildon-fmmm/file-details-dialog.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  button_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "to select a file")
{
  set_title("Hildon::FileDetailsDialog Example");

  add(box_);

  box_.pack_start(button_, Gtk::PACK_SHRINK);
  button_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_clicked()
{
  Hildon::FileChooserDialog dialog(*this, Gtk::FILE_CHOOSER_ACTION_OPEN);

  Gtk::FileFilter filter_any;
  filter_any.set_name("Any Files");
  filter_any.add_pattern("*");
  dialog.add_filter(filter_any);

  //Show the dialog and wait for a user response:
  int response = dialog.run();

  //Handle the response:
  switch(response)
  {
    case(Gtk::RESPONSE_OK):
    {
      const std::string filename = dialog.get_filename();
      std::cout << "filename chosen: " << filename << std::endl;

      // Create a Hildon::FileSystemModel
      Glib::RefPtr<Hildon::FileSystemModel> fs_model = 
        Hildon::FileSystemModel::create(*this /* ref-widget */);


      // Create a Hildon::FileDetailsDialog
      Hildon::FileDetailsDialog fd_dialog(fs_model);


      // Tell the FileDetailsDialog to show this file:
      Gtk::TreeModel::iterator iter = fs_model->load_local_path(filename);
      //TODO (low priority): load_local_path() always seems to return a null iter.
      if(iter)
      {
        fd_dialog.set_file_iter(iter);
      }
      else
        std::cerr << "Hildon::FileSystemModel::load_local_path(" << filename <<
          ") failed" << std::endl;


      // Show the dialog:
      fd_dialog.set_transient_for(*this);
      fd_dialog.run();

      break;
    }
    case(Gtk::RESPONSE_CANCEL):
    {
      std::cout << "Cancel clicked." << std::endl;
      break;
    }
    default:
    {
      std::cerr << "Unexpected button clicked." << std::endl;
      break;
    }
  }
  
}
