
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  box_(false, 6), //TODO: See https://bugs.maemo.org/show_bug.cgi?id=4464 for correct spacing.
  entry_name_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH |
    Gtk::Hildon::SIZE_FINGER_HEIGHT),
  entry_street_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH |
    Gtk::Hildon::SIZE_FINGER_HEIGHT),
  entry_position_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH |
    Gtk::Hildon::SIZE_FINGER_HEIGHT),
  icon1_(Gtk::Stock::NEW, Gtk::ICON_SIZE_BUTTON),
  icon2_(Gtk::Stock::NEW, Gtk::ICON_SIZE_BUTTON),
  icon3_(Gtk::Stock::NEW, Gtk::ICON_SIZE_BUTTON)
{
  set_title("Hildon::Caption Example");

  // A silly test:
  entry_name_.set_placeholder("Mr. Example");
  group_ = Gtk::SizeGroup::create(Gtk::SIZE_GROUP_VERTICAL);
  
  // Create the captions:
  Hildon::Caption* caption_name = Gtk::manage(
    new Hildon::Caption(group_, "Name", entry_name_, icon1_));
  caption_name->signal_activate().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_activate));

  Hildon::Caption* caption_street = Gtk::manage(
    new Hildon::Caption(group_, "Street", entry_street_, icon2_));
  caption_street->signal_activate().connect(sigc::mem_fun(*this,
    &ExampleWindow::on_activate));
  
  Hildon::Caption* caption_position = Gtk::manage(
    new Hildon::Caption(group_, "Position", entry_position_, icon3_));
  caption_position->signal_activate().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_activate));

  box_.pack_start(*caption_name, Gtk::PACK_SHRINK);
  box_.pack_start(*caption_street, Gtk::PACK_SHRINK);
  box_.pack_start(*caption_position, Gtk::PACK_SHRINK);
  add(box_);  
  
  // Make all child widgets visible,
  // so they will be visible when this window is shown:
  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_activate()
{
  std::cout << "Caption activated." << std::endl;
}
