
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <hildonmm/program.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  button1_("Button 1"),
  button2_("Button 2"),
  radio1_("Radio 1"),
  radio2_("Radio 2"),
  toggle1_("Toggle 1"),
  toggle2_("Toggle 2"),
  label_("Hildon::AppMenu example. Click window title to display menu.")
{
  set_title("Hildon::AppMenu Example");
  Hildon::Program::get_instance()->set_common_app_menu(menu_);

  // Setup radio buttons to be in one group.
  radio1_.set_active();
  Gtk::RadioButton::Group radio_group = radio1_.get_group();
  radio2_.set_group(radio_group);

  // Add buttons and filters to AppMenu.
  menu_.append(button1_);
  menu_.append(button2_);
  menu_.add_filter(radio1_);
  menu_.add_filter(radio2_);
  menu_.add_filter(toggle1_);
  menu_.add_filter(toggle2_);

  add(label_);

  // Connect signal handlers.
  button1_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button1_clicked));
  button2_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button2_clicked));
  radio1_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_radio_toggled));
  toggle1_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_toggle1_toggled));
  toggle2_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_toggle1_toggled));

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button1_clicked()
{
  std::cout << "Button 1 clicked" << std::endl;
}

void ExampleWindow::on_button2_clicked()
{
  std::cout << "Button 2 clicked" << std::endl;
}

void ExampleWindow::on_radio_toggled()
{
  std::cout << "Radio button toggled, current state: Radio 1=" <<
    radio1_.get_active() << ", Radio 2=" << radio2_.get_active() << std::endl;
}

void ExampleWindow::on_toggle1_toggled()
{
  std::cout << "Toggle 1 toggled, current state=" << toggle1_.get_active() <<
    std::endl;
}

void ExampleWindow::on_toggle2_toggled()
{
  std::cout << "Toggle 2 toggled, current state=" << toggle2_.get_active() <<
    std::endl;
}
