/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <hildonmm/wizard-dialog.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  button_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Show wizard",
    "by clicking this button")
{
  set_title("Hildon::WizardDialog example");

  add(box_);

  box_.pack_start(button_, Gtk::PACK_SHRINK);
  button_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));

  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_clicked()
{
  ExampleWizard dialog;
  dialog.set_transient_for(*this);

  int response = dialog.run();
  
  //Handle the response:
  switch(response)
  {
    case(2): //TODO: Use the correct enums when the patch in bug #884 has been applied. 
    {
      std::cout << "Finish clicked." << std::endl;
      break;
    }
    case(Gtk::RESPONSE_CANCEL): //TODO: Use the correct enums when the patch in bug #884 has been applied. 
    {
      std::cout << "Cancel clicked." << std::endl;
      break;
    }
    default:
    {
      std::cout << "Unexpected button clicked: " << response << std::endl;
      break;
    }
  }
  
}
