/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow()
{
  set_title("UIManager example");

  // Create actions for menus and toolbars:
  actiongroup_ = Gtk::ActionGroup::create();

  // File|New sub menu:
  actiongroup_->add(Gtk::Action::create("FileNewStandard", Gtk::Stock::NEW, "_New", "Create a new file"),
    sigc::mem_fun(*this, &ExampleWindow::on_action_file_new));

  actiongroup_->add(Gtk::Action::create("FileNewFoo", Gtk::Stock::NEW, "New Foo", "Create a new foo"),
    sigc::mem_fun(*this, &ExampleWindow::on_action_file_new));

  actiongroup_->add(Gtk::Action::create("FileNewGoo", Gtk::Stock::NEW, "_New Goo", "Create a new goo"),
    sigc::mem_fun(*this, &ExampleWindow::on_action_file_new));

  // File menu:
  actiongroup_->add(Gtk::Action::create("FileMenu", "File"));
  actiongroup_->add(Gtk::Action::create("FileNew", Gtk::Stock::NEW)); // Sub-menu.
  actiongroup_->add(Gtk::Action::create("FileQuit", Gtk::Stock::QUIT),
    sigc::mem_fun(*this, &ExampleWindow::on_action_file_quit));

  uimanager_ = Gtk::UIManager::create();
  uimanager_->insert_action_group(actiongroup_);
 
  add_accel_group(uimanager_->get_accel_group());

  /* Layout the actions in a menu and toolbar. In Hildon you have to use
   *  "popup" for the menu because you can only have one menu and cannot add
   *  a whole menubar. */
  
  Glib::ustring ui_info = 
        "<ui>"
        "    <popup action='FileMenu'>"
        "      <menu action='FileNew'>"
        "        <menuitem action='FileNewStandard'/>"
        "        <menuitem action='FileNewFoo'/>"
        "        <menuitem action='FileNewGoo'/>"
        "      </menu>"
        "      <separator/>"
        "      <menuitem action='FileQuit'/>"
        "    </popup>"
        "  <toolbar  name='ToolBar'>"
        "    <toolitem action='FileNewStandard'/>"
        "    <toolitem action='FileQuit'/>"
        "  </toolbar>"
        "</ui>";

  std::auto_ptr<Glib::Error> ex;
  uimanager_->add_ui_from_string(ui_info, ex);
  if(ex.get())
  { 
    std::cerr << "building menus failed: " <<  ex->what();
  }
 
  // Get the menu and toolbar widgets, and add them to a container widget:
  Gtk::Menu* menu = dynamic_cast<Gtk::Menu*>(uimanager_->get_widget("/FileMenu"));
  if(menu)
    set_main_menu(*menu);

  Gtk::Toolbar* toolbar = dynamic_cast<Gtk::Toolbar*>(uimanager_->get_widget("/ToolBar"));
  if(toolbar)
    add_toolbar(*toolbar);
  
  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_action_file_quit()
{
  hide(); // Closes the main window to stop the Gtk::Main::run().
}

void ExampleWindow::on_action_file_new()
{
   std::cout << "A File|New action was selected." << std::endl;
}

void ExampleWindow::on_action_others()
{
  std::cout << "An action was selected." << std::endl;
}

