/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  tool_new_(Gtk::Stock::NEW),
  tool_open_(Gtk::Stock::OPEN),
  tool_save_(Gtk::Stock::SAVE),
  tool_close_(Gtk::Stock::CLOSE)
{
  set_title("Toolbar example");

  // Create Combobox on tool item.
  Gtk::ComboBoxText* combo = Gtk::manage(new Gtk::ComboBoxText);
  combo->append_text("Entry 1");
  combo->append_text("Entry 2");
  combo->append_text("Entry 3");
  combo->set_active(1);
  tool_combo_.add(*combo);
  tool_combo_.set_expand();
    
  // Add toolbar items to toolbar.
  toolbar_.append(tool_new_);
  toolbar_.append(tool_separator_);
  toolbar_.append(tool_open_);
  toolbar_.append(tool_save_);
  toolbar_.append(tool_combo_);
  toolbar_.append(tool_close_);
  
  // Add toolbar.
  add_toolbar(toolbar_);
  toolbar_.show_all(); //Show the toolbar and all its child widgets.

  // Attach the callback functions to the activate signal.
  tool_close_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_item_close));
  
  // Make all child widgets visible
  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_item_close()
{
  hide();
}

