/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow() :
	pickerbutton(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
		     Hildon::BUTTON_ARRANGEMENT_VERTICAL)
{
  set_title("Hildon::PickerButton example");

  Gtk::TreeModelColumnRecord columns;
  Gtk::TreeModelColumn<Glib::ustring> text_column;
  columns.add(text_column);
  Glib::RefPtr<Gtk::ListStore> list_store = Gtk::ListStore::create(columns);
  Glib::RefPtr<Hildon::TouchSelectorColumn> text_col = touchselector.append_text_column(list_store);
  g_object_set(text_col->gobj(), "text-column", 0, static_cast<char*>(0));
  touchselector.append_text("Africa");
  touchselector.append_text("Antarctica");
  touchselector.append_text("Asia");
  touchselector.append_text("Australia");
  touchselector.append_text("Europe");
  touchselector.append_text("North America");
  touchselector.append_text("South America");
  pickerbutton.set_selector(touchselector);
  pickerbutton.set_title("Select a continent");

  box.add(pickerbutton);
  add(box);

  pickerbutton.signal_value_changed().connect(sigc::mem_fun(*this, &ExampleWindow::on_value_changed) );

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_value_changed()
{
  std::cout << "Selection changed! Current state=" << touchselector.get_current_text() << std::endl;
}

