/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <hildonmm/banner.h>

ExampleWindow::ExampleWindow() 
{
  signal_key_press_event().connect(sigc::mem_fun(*this, &ExampleWindow::on_key_pressed));

  show_all();
}

ExampleWindow::~ExampleWindow()
{
  
}

bool ExampleWindow::on_key_pressed(GdkEventKey* event)
{
  if(!event)
    return false;

  switch (event->keyval)
  {
    case GDK_Up:
      Hildon::Banner::show_information(*this, "Key Up");
      break;
    case GDK_Down:
      Hildon::Banner::show_information(*this, "Key Down");
      break;
    case GDK_Left:
      Hildon::Banner::show_information(*this, "Key Left");
      break;
    case GDK_Right:
      Hildon::Banner::show_information(*this, "Key Right");
      break;
    case GDK_Return:
      Hildon::Banner::show_information(*this, "Key Select");
      break;
    case GDK_Escape:
      Hildon::Banner::show_information(*this, "Key Cancel");
      break;
    case GDK_F4:
      Hildon::Banner::show_information(*this, "Open menu");
      break;
    case GDK_F5:
      Hildon::Banner::show_information(*this, "Show Home");
      break;
    case GDK_F6:
      Hildon::Banner::show_information(*this, "Full screen");
      break;
    case GDK_F7:
      Hildon::Banner::show_information(*this, "Increase");
      break;
    case GDK_F8:
      Hildon::Banner::show_information(*this, "Decrease");
      break;
    default:
      Hildon::Banner::show_information(*this, "Other key");
  }
  
  // Returning true would stop the event now.
  return false;
}
