/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow() :
  toolbar_("Click confirm or the back arrow", "Confirm")
{
  set_title("Hildon::EditToolbar example");

  set_edit_toolbar(toolbar_);

  toolbar_.signal_button_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  toolbar_.signal_arrow_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_arrow_clicked));

  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_clicked()
{
  unset_edit_toolbar();
  std::cout << "Button clicked." << std::endl;
}

void ExampleWindow::on_arrow_clicked()
{
  unset_edit_toolbar();
  std::cout << "Arrow clicked." << std::endl;
}
