/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow()
{
  set_title("Hildon::DateButton example");

  buttonbox_.pack_start(datebutton_);
  add(buttonbox_);

  datebutton_.signal_value_changed().connect(sigc::mem_fun(*this, &ExampleWindow::on_button_changed));

  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_changed()
{
  guint year = 0;
  guint month = 0;
  guint day = 0;
  datebutton_.get_date(year, month, day);
  std::cout << "Date chosen: year=" << year << ", month=" << month << ", day=" << day << std::endl;
}

