/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <hildonmm/program.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  button1_("Button 1"),
  button2_("Button 2"),
  radio1_("Radio 1"),
  radio2_("Radio 2"),
  toggle1_("Toggle 1"),
  toggle2_("Toggle 2"),
  label_("Hildon::AppMenu example. Click window title to display menu.")
{
  set_title("Hildon::AppMenu example");
  Hildon::Program::get_instance()->set_common_app_menu(menu_);

  // Setup radio buttons to be in one group.
  radio1_.set_active();
  Gtk::RadioButton::Group radio_group = radio1_.get_group();
  radio2_.set_group(radio_group);

  // Add buttons and filters to AppMenu.
  menu_.append(button1_);
  menu_.append(button2_);
  menu_.add_filter(radio1_);
  menu_.add_filter(radio2_);
  menu_.add_filter(toggle1_);
  menu_.add_filter(toggle2_);

  add(label_);

  // Connect signal handlers.
  button1_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_button1_clicked));
  button2_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_button2_clicked));
  radio1_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_radio_toggled));
  toggle1_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_toggle1_toggled));
  toggle2_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_toggle1_toggled));

  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button1_clicked()
{
  std::cout << "Button 1 clicked" << std::endl;
}

void ExampleWindow::on_button2_clicked()
{
  std::cout << "Button 2 clicked" << std::endl;
}

void ExampleWindow::on_radio_toggled()
{
  std::cout << "Radio button toggled, current state: Radio 1=" << radio1_.get_active() << ", Radio 2=" << radio2_.get_active() << std::endl;
}

void ExampleWindow::on_toggle1_toggled()
{
  std::cout << "Toggle 1 toggled, current state=" << toggle1_.get_active() << std::endl;
}

void ExampleWindow::on_toggle2_toggled()
{
  std::cout << "Toggle 2 toggled, current state=" << toggle2_.get_active() << std::endl;
}
