import os
import os.path
import re
import sys
import time
import httplib
import urllib
import datetime
import commands
from PyJson.json import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *

app = QApplication(sys.argv)

ROOT_PATH = '/opt/maemoapp/'
API_HOST = 'www.maemoapp.com'
API_URI_APPLIST = '/api/apps.asp'
API_URI_USERS = '/api/users.asp'
API_URI_LOGIN = '/api/login.asp'
API_URI_MSG = '/api/message.asp'
API_URI_UPDATEGPS = '/api/updategps.asp'

URL_REG = 'http://www.maemoapp.com/Passport/Reg.asp'

VAR_USERID = 0
VAR_USERNAME = ''
VAR_PASSWORD = ''

def url_changed(url): 
    print 'url changed: ', url
    doParseCommand(url)
    
    #if url change then get new message.
    doParseMessage()

def doParseCommand(url):
    global VAR_USERID, VAR_USERNAME, VAR_PASSWORD
    
    url = url.toString()
    url = url.split('#')
    
    if len(url) > 1:
        tmpAry = url[1].split('_')
        if len(tmpAry) >= 3:
            print tmpAry[0], tmpAry[1], tmpAry[2]
            
            if tmpAry[0]=='downloadapps':
                if tmpAry[1]=='searchapp':
                    ObjHttp = httplib.HTTPConnection(API_HOST) 
                    ObjHttp.request('get', str(API_URI_APPLIST + '?keyword=' + tmpAry[2]))  
                    tmpContent = ObjHttp.getresponse().read()
                    ObjHttp.close()
                    
                    file_object = open(ROOT_PATH+'cache/apps/search_'+tmpAry[2]+'.txt', 'w')
                    file_object.writelines(tmpContent)
                    file_object.close()
                elif tmpAry[1]=='downloadapp':
                    print tmpAry[2],tmpAry[3],tmpAry[4]
                    doDownloadAndInstall(tmpAry[2],tmpAry[3],tmpAry[4])
                else:
                    ObjHttp = httplib.HTTPConnection(API_HOST)
                    ObjHttp.request('get', str(API_URI_APPLIST + '?classid=' + tmpAry[2] + '&order='+tmpAry[3]))
                    tmpContent = ObjHttp.getresponse().read()
                    ObjHttp.close()
                    
                    file_object = open(ROOT_PATH+'cache/apps/class'+tmpAry[2]+'_'+tmpAry[3]+'.txt', 'w')
                    file_object.writelines(tmpContent)
                    file_object.close()
                    
                    
            elif tmpAry[0]=='searchpackage':
                if tmpAry[1]=='keyword':
                    if os.path.isfile(ROOT_PATH+'cache/searchpackage/packages.txt'): os.remove(ROOT_PATH+'cache/searchpackage/packages.txt')
                    
                    ObjHttp = httplib.HTTPConnection('maemo.org')
                    ObjHttp.request('get', '/packages/search/?org_maemo_packages_search%5B1%5D%5Bproperty%5D=name&org_maemo_packages_search%5B1%5D%5Bconstraint%5D=LIKE&org_maemo_packages_search%5B1%5D%5Bvalue%5D='+str(tmpAry[2])+'&org_maemo_packages_search%5B2%5D%5Bproperty%5D=title&org_maemo_packages_search%5B2%5D%5Bconstraint%5D=LIKE&org_maemo_packages_search%5B2%5D%5Bvalue%5D=same')
                    tmpContent = ObjHttp.getresponse().read()
                    ObjHttp.close()
                
                    if tmpContent:
                        pattern = re.compile(r'<div class="search_result_item">(\s+?)<a href="(.*)">(.*)</a> (.*)</div>')
                        tmpAry = pattern.findall(tmpContent)
                        if tmpAry:            
                            file_object = open(ROOT_PATH+'cache/searchpackage/packages.txt', 'w+')
                            
                            for tmpSubAry in tmpAry:
                                print tmpSubAry
                                output = '<div class="Item Left" onclick="doInstallPackage(\''+tmpSubAry[2]+'\');"><div class="Name Left">'+tmpSubAry[3]+'</div><div class="Package Left">'+tmpSubAry[2]+'</div><div class="AppBtn Right">[Install]</div></div>'
                                
                                file_object.write(output)
                                
                            file_object.close()
                elif tmpAry[1]=='install':
                    print "install"
                    
                    os.environ["packagename"] = str(tmpAry[2])
                    os.system('osso-xterm -e "apt-get install $packagename" &')
                
            
            elif tmpAry[0]=='debugapps':
                if tmpAry[1]=='run':
                    tmpAppName = ""
                    tmpNum = len(tmpAry)
                    if tmpNum >= 3:
                        for i in range(2, tmpNum):
                            tmpAppName += tmpAry[i]+'_'
                            
                    tmpAppName = tmpAppName[0:-1]
                    print "Run "+tmpAppName+" as debug mode"
                    doDebug(tmpAppName)
                elif tmpAry[1]=='load' and tmpAry[2]=='apps':
                    print "doLoadApps"
                    doLoadApps()
            
            elif tmpAry[0]=='allmaemousers':
                print "allmaemousers"
                if tmpAry[1]=='load':
                
                    ObjHttp = httplib.HTTPConnection(API_HOST)
                    ObjHttp.request('get', str(API_URI_USERS + '?userid=' + str(VAR_USERID)))
                    tmpContent = ObjHttp.getresponse().read()
                    ObjHttp.close()
                    
                    if tmpContent[0:8]=="errcode:":
                        tmpErrCode = tmpContent[8:]
                        
                        if tmpErrCode == '1':
                            doMessageShow('Error: user not login')
                        elif tmpErrCode == '2':
                            doMessageShow('Error: user not update gps data')
                    else:
                        file_object = open(ROOT_PATH+'cache/users/users.txt', 'w')
                        file_object.writelines(tmpContent)
                        file_object.close()
                        
                elif tmpAry[1]=='update':
                    
                    # append gps info.
                    ret = os.popen('python2.5 '+ROOT_PATH+'location.gps.py').read()
                    
                    if ret.find(',') > -1:
                        tmpParam = ret.split(',')
                        print 'lat:' + tmpParam[0]
                        print 'long:' + tmpParam[1][0:-1]
                        
                        tmpLocation = tmpParam[1]+','+tmpParam[0]
                        
                        tmpParams = urllib.urlencode({"userid": VAR_USERID, "password": VAR_PASSWORD, "location": tmpLocation })
                        tmpHeaders = {"Content-Type":"application/x-www-form-urlencoded", "Connection":"Keep-Alive"}
                        ObjHttp = httplib.HTTPConnection(API_HOST)
                        ObjHttp.request('post', API_URI_UPDATEGPS, tmpParams, tmpHeaders)
                        tmpContent = ObjHttp.getresponse().read()
                        ObjHttp.close()
                        
                        print tmpContent
                        if tmpContent=='ok':
                            doMessageShow('Your GPS info are update to maemoapp.com server.')
                    else:
                        doMessageShow('Cann\'t start GPS module.')
                        
                else:
                    print 'other'
            elif tmpAry[0]=='account':
                if tmpAry[1]=='login':
                    tmpParams = urllib.urlencode({"userid": tmpAry[2], "password": tmpAry[3]})
                    tmpHeaders = {"Content-Type":"application/x-www-form-urlencoded", "Connection":"Keep-Alive"}
                    ObjHttp = httplib.HTTPConnection(API_HOST)
                    ObjHttp.request('post', API_URI_LOGIN, tmpParams, tmpHeaders)
                    tmpContent = ObjHttp.getresponse().read()
                    ObjHttp.close()
                    
                    doParseResponse(tmpContent)
                    
                elif tmpAry[1]=='logout':
                    if os.path.isfile(ROOT_PATH+'cache/account/session.txt'): os.remove(ROOT_PATH+'cache/account/session.txt')
                    VAR_USERID = 0
                    
                elif tmpAry[1]=='reg':
                    try:
                        os.system('dbus-send --system --type=method_call --dest=com.nokia.osso_browser /com/nokia/osso_browser/request com.nokia.osso_browser.load_url string:"' + URL_REG + '"')
                    except:
                        print "Debug:"
                        print tmpURL
                        print "Maemo5 Broswer have a Bug."
                elif tmpAry[1]=='sayhi':
                    
                    tmpParams = urllib.urlencode({"action": "sayhi", "userid": VAR_USERID, "password": VAR_PASSWORD, "m_userid": tmpAry[2], "remark": "sayhi"})
                    tmpHeaders = {"Content-Type":"application/x-www-form-urlencoded", "Connection":"Keep-Alive"}
                    ObjHttp = httplib.HTTPConnection(API_HOST)
                    ObjHttp.request('post', API_URI_MSG, tmpParams, tmpHeaders)
                    tmpContent = ObjHttp.getresponse().read()
                    ObjHttp.close()
                    
                    print tmpContent
                    if tmpContent=='ok':
                        doMessageShow('Say Hi to this user success! please wait reply.')
                

def doParseResponse(strer):
    if os.path.isfile(ROOT_PATH+'cache/account/session.txt'): os.remove(ROOT_PATH+'cache/account/session.txt')
    
    if strer[0:8]=="errcode:":
        tmpErrCode = strer[8:]
        
        if tmpErrCode == '1':
            doMessageShow('Error: not post userid')
        elif tmpErrCode == '2':
            doMessageShow('Error: not post password')
        elif tmpErrCode == '3':
            doMessageShow('Error: userid or password error')
        elif tmpErrCode == '4':
            doMessageShow('Error: userid or password error')
    else:
        file_object = open(ROOT_PATH+'cache/account/session.txt', 'w')
        file_object.writelines(strer)
        file_object.close()
        
        doParseLogin()
        
def doParseMessage():
    global VAR_USERID, VAR_USERNAME, VAR_PASSWORD
    
    print "get new message."
    if int(VAR_USERID)>0:
        tmpLastID = 0;
        
        if os.path.isfile(ROOT_PATH+'cache/account/message.txt'):
            file_object = open(ROOT_PATH + 'cache/account/message.txt')
            try:
                 tmpContent = file_object.read( )
            finally:
                 file_object.close()
            
            if tmpContent:
                tmpJsonReturn = JsonReader().read(tmpContent)
                
                if len(tmpJsonReturn)>0:
                    tmpLastID = tmpJsonReturn[0]['m_id']
        
        print tmpLastID
        
        tmpParams = urllib.urlencode({"userid": VAR_USERID, "password": str(VAR_PASSWORD), "lastid": tmpLastID})
        tmpHeaders = {"Content-Type":"application/x-www-form-urlencoded", "Connection":"Keep-Alive"}
        ObjHttp = httplib.HTTPConnection(API_HOST)
        ObjHttp.request('post', API_URI_MSG, tmpParams, tmpHeaders)
        tmpContent = ObjHttp.getresponse().read()
        ObjHttp.close()
        
        if tmpContent[0:8]=="errcode:":
            tmpErrCode = tmpContent[8:]
            
            if tmpErrCode == '1':
                doMessageShow('Error: no userid')
            elif tmpErrCode == '2':
                doMessageShow('Error: password is not')
            elif tmpErrCode == '3':
                doMessageShow('Error: password is not safe')
            elif tmpErrCode == '4':
                doMessageShow('Error: user password error, 1')
            elif tmpErrCode == '5':
                doMessageShow('Error: user password error, 2')
            elif tmpErrCode == '6':
                doMessageShow('Error: sender not find')
            elif tmpErrCode == '7':
                doMessageShow('Error: accept not find')
        else:
            
            if len(tmpContent)>10:
                tmpReJsonReturn = JsonReader().read(tmpContent)
                
                if tmpLastID>0:
                    tmpReJsonReturn.extend(tmpJsonReturn)
                
                tmpContent = JsonWriter().write(tmpReJsonReturn)
                
                file_object = open(ROOT_PATH+'cache/account/message.txt', 'w+')
                file_object.writelines(tmpContent)
                file_object.close()
                
                print "hava new message!"
    
        
def doParseLogin():
    global VAR_USERID, VAR_USERNAME, VAR_PASSWORD
    if os.path.isfile(ROOT_PATH+'cache/account/session.txt'):
        file_object = open(ROOT_PATH + 'cache/account/session.txt')
        try:
             tmpContent = file_object.read( )
        finally:
             file_object.close()
             
        print "Login:" + tmpContent
        
        tmpAry = tmpContent.split('|')
        VAR_USERID = tmpAry[0]
        VAR_USERNAME = tmpAry[1]
        VAR_PASSWORD = tmpAry[2]
        VAR_PASSWORD = VAR_PASSWORD[0:16]
        
    else:
        print "Not Login."
         
    
    
def doDownloadAndInstall(strClassid, strOrder, strDid):
    file_object = open(ROOT_PATH + 'cache/apps/class'+strClassid+'_'+strOrder+'.txt')
    try:
         tmpContent = file_object.read( )
    finally:
         file_object.close()
    
    tmpJsonReturn = JsonReader().read(tmpContent)
    
    for tmpItem in tmpJsonReturn:
        if str(tmpItem['d_id']) == str(strDid):
            tmpURL = tmpItem['d_url1']
            tmpDebName = tmpURL[tmpURL.rfind('/')+1:]
            
            #download file
            (status, output) = commands.getstatusoutput('osso-xterm -e "wget '+tmpURL+' -c -N -P "'+ROOT_PATH+'cache/appfiles/" "')
            print status, output
            if (status == 0):
                #install file
                (status, output) = commands.getstatusoutput('osso-xterm -e "dpkg -i "'+ROOT_PATH+'cache/appfiles/'+tmpDebName+'" "')
                print status, output
                if (status == 0):
                    print "installed"
                    doMessageShow('installed')
                else:
                    print "install failed."
                    doMessageShow('Install failed:<br />'+output)
            else:
                print "download failed."
                doMessageShow('Download failed:<br />'+output)
            
def doLoadApps():
    if os.path.isfile(ROOT_PATH+'cache/debugapps/Apps.txt'): os.remove(ROOT_PATH+'cache/debugapps/Apps.txt')
    
    
    file_object = open(ROOT_PATH+'cache/debugapps/Apps.txt', 'w+')
    
    for tmpfile in os.listdir('/usr/share/applications/hildon/'):
    
        tmpfile = tmpfile.replace('.desktop', '')
        tmpIcon = getExecuteLine(tmpfile, 'Icon=')
        tmpIcon = getIconPath(tmpIcon)
        
        output = '<div class="Item Left" onclick="javascript:doPrviewAppInfo(\''+tmpfile+'\', \''+tmpIcon+'\');"><img width="64" height="64" src="file://'+tmpIcon+'" /></div>'
        
        file_object.write(output)
        
    file_object.close()
    
def doDebug(strFile):
    (status, output) = commands.getstatusoutput(getExecuteLine(strFile, 'Exec='))
    #print status, output
    file_object = open(ROOT_PATH+'debug/'+strFile+'.log', 'w')
    file_object.writelines(output)
    file_object.close()
    
    
def getExecuteLine(strFile, strNode):
    file_object = open('/usr/share/applications/hildon/'+strFile+'.desktop')
    
    tmpNodeLen = len(strNode)
    for line in file_object:
        if line[0:tmpNodeLen]==strNode:
            #print line[tmpNodeLen:-1]
            file_object.close()
            return line[tmpNodeLen:-1]
    
    file_object.close()
    
def getIconPath(strIcon):
    if strIcon == None:
        return ROOT_PATH+"images/icon_noicon.png"
    else:
        tmpIconFolders = [ "/usr/share/pixmaps/", "/usr/share/icons/hicolor/scalable/apps/", "/usr/share/icons/hicolor/scalable/hildon/", "/usr/share/icons/hicolor/64x64/apps/", "/usr/share/icons/hicolor/64x64/hildon/", "/usr/share/icons/hicolor/48x48/apps/", "/usr/share/icons/hicolor/48x48/hildon/" ]
        for tmpIconFolder in tmpIconFolders:
            if os.path.isfile(tmpIconFolder + strIcon + '.png'):
                #print tmpIconFolder + strIcon + '.png'
                return tmpIconFolder + strIcon + '.png'

        return ROOT_PATH+"images/icon_noicon.png"



################## SYS MSG ######################

def doMessageShow(strMessage):
    #global ObjMessageForm
    ObjMessageForm=MessageForm(strMessage, BrowserWindow)
    ObjMessageForm.show()
    
def doMessageHide():
    #global ObjMessageForm
    ObjMessageForm.close()
    
class MessageForm(QDialog):
    def __init__(self, Message, parent=None):
        super(MessageForm, self).__init__(parent)
        
        tmpString="""
            <div style="padding:10px;">
                %s
            </div>
            """ % (Message)
        self.setWindowTitle(unicode("MaemoApp Message"))
        self.aboutLabel=QLabel()
        self.aboutLabel.setText(tmpString)
        self.aboutLabel.setWordWrap(True)
        self.formLayout=QFormLayout(self)
        self.formLayout.addRow(self.aboutLabel)



BrowserWindow = QWebView()
BrowserWindow.load(QUrl("file://"+ROOT_PATH+"UI.html"))
BrowserWindow.connect(BrowserWindow, SIGNAL("urlChanged(const QUrl&)"), url_changed)
BrowserWindow.setWindowTitle("MaemoApp")
BrowserWindow.show()

doParseLogin()


sys.exit(app.exec_())

#        BrowserWindow.page().setLinkDelegationPolicy(QWebPage.DelegateAllLinks)
#        BrowserWindow.connect(self,
#                     SIGNAL("loadFinished(bool)"),
#                     self.loadfinished)

#        BrowserWindow.connect(self,
#                     SIGNAL("linkClicked(const QUrl&)"),
#                     self.urlClicked)

#def loadfinished(self, strOK):
#    print "debug!loadfinished!"
#    print strOK

#
#        self.avatarLabel.setHtml(total_html)  
        
