/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    currentprofile.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef CURRENTPROFILE_H
#define CURRENTPROFILE_H
#include "conditioninterface.h"
#include <QSystemDeviceInfo>

QTM_USE_NAMESPACE

class CurrentProfile : public Condition
{
	Q_OBJECT
	Q_PROPERTY(int selectedProfileState READ getSelectedProfileState WRITE setSelectedProfileState NOTIFY notifySelectedProfileState)

public:
	explicit CurrentProfile(ConditionInterface *interface);



	inline int getSelectedProfileState() const { return selectedProfileState;}
	inline void setSelectedProfileState(int i) { selectedProfileState = i; emit notifySelectedProfileState(); update();}

	Q_INVOKABLE int getProfileState() { return deviceInfo->currentProfile(); }

	virtual void load(const QByteArray &data);
	virtual QByteArray save() const;
	void update();
signals:
	void notifySelectedProfileState();
	void notifyProfileStateChanged();
public slots:
	void  profileStateChanged(QSystemDeviceInfo::Profile);
private:

	int selectedProfileState;


	QSystemDeviceInfo * deviceInfo;


};
//====================================================
class CurrentProfileInterface : public ConditionInterface
{
	Q_OBJECT
	Q_INTERFACES(ConditionInterface)

public:
	virtual QString name() const { return tr("Current Profile"); }
	virtual QString vendor() const { return tr("Profiler Team"); }
	virtual QString version() const { return "0.1"; }

	virtual CurrentProfile *createCondition() { return new CurrentProfile(this); }

	virtual QUrl qmlGUIFile() const { return QUrl("qrc:CurrentProfile.qml"); }
	virtual QUrl icon() const { return QUrl("qrc:sound.png"); }
};
//====================================================

#endif // CURRENTPROFILE_H
