/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    vibration.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include "vibration.h"
#include <QTimer>
#include <QDebug>
#include <QDBusConnection>
#include <QDBusMessage>

#include <mce/dbus-names.h>

static void checkError(QDBusMessage &msg)
{
	if (msg.type() == QDBusMessage::ErrorMessage)
		qDebug() << msg.errorName() << msg.errorMessage();
}

Vibration::Vibration(ActionInterface *interface) :
	Action(interface),mceInterface(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF,
								   QDBusConnection::systemBus())
{  
	QDBusMessage reply = mceInterface.call(MCE_ENABLE_VIBRATOR);
	checkError(reply);

	timer = new QTimer(this);
	timer->setSingleShot(true);//je single shot !!
	connect(timer,SIGNAL(timeout()),this,SLOT(stop()));
	lastPatternName = "PatternIncomingCall";//co se bude volat
}


Vibration::~Vibration()
{
	stopAction();
	QDBusMessage reply = mceInterface.call(MCE_DISABLE_VIBRATOR);
	checkError(reply);
}

void Vibration::doAction()
{
	stopAction();
	QDBusMessage reply = mceInterface.call(MCE_ACTIVATE_VIBRATOR_PATTERN, lastPatternName);
	checkError(reply);
	qDebug() << "za 10 sec";
	timer->start(10000);
}

void Vibration::stopAction()
{
	timer->stop();

	if (!lastPatternName.isNull()) {
		QDBusMessage reply = mceInterface.call(MCE_DEACTIVATE_VIBRATOR_PATTERN, lastPatternName);
		checkError(reply);
	}
	qDebug() << "stop akce";
}

void Vibration::load(const QByteArray &data)
{
	QDataStream stream(data);
}

QByteArray Vibration::save() const
{
	QByteArray data;
	QDataStream stream(&data, QIODevice::WriteOnly);
	return data;
}

void Vibration::stop()
{
	stopAction();
}

void Vibration::start()
{
	doAction();
}
Q_EXPORT_PLUGIN2(vibration, VibrationInterface)
