/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    dialognotification.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include "dialognotification.h"
#include <QDebug>
#include <QtDBus/QDBusInterface>
#include <QTimer>
DialogNotification::DialogNotification(ActionInterface *interface) :
    Action(interface)
{
    connectionInterface = new QDBusInterface( "org.freedesktop.Notifications",
					     "/org/freedesktop/Notifications",
					     "org.freedesktop.Notifications",
					     QDBusConnection::sessionBus(),
					      this );
    message = QString("");
}

void DialogNotification::doAction()
{
    if(message.size() == 0) return;
    if( !connectionInterface->isValid(  ) )
    {
	qWarning(  ) << "Cannotct connect to D-BUS";
    }
    else
    {
	connectionInterface->call( QLatin1String( "SystemNoteDialog" ),
				   QVariant( message ),static_cast<quint32>(0),QVariant(QString("OK")) );
    }
}

void DialogNotification::stopAction()
{
}

void DialogNotification::load(const QByteArray &data)
{
	QDataStream stream(data);
	stream >>  message;
}

QByteArray DialogNotification::save() const
{
	QByteArray data;
	QDataStream stream(&data, QIODevice::WriteOnly);
	stream << message;
	return data;
}

Q_EXPORT_PLUGIN2(dialognotification, DialogNotificationInterface)
