/*
Copyright (c) 2012, Petr Pehal, Jakub  plíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    profile.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef PROFILE_H
#define PROFILE_H

#include <QObject>
#include "../interface/conditioninterface.h"
#include "../interface/actioninterface.h"

/*************************************************************************************************/
// PROFILE DATA
/*************************************************************************************************/

struct ProfileData
{
	QString    name;

	Conditions conditions;
	Actions    actions;

	quint16 active   : 1,
		doingActions : 1,
		_reserved    : 14;
};

/*************************************************************************************************/
// PROFILE DATA
/*************************************************************************************************/

class Profile : public QObject
{
	Q_OBJECT
	Q_PROPERTY(bool    active        READ isActive        WRITE setActive NOTIFY activeChanged)
	Q_PROPERTY(QString name          READ name            WRITE setName   NOTIFY nameChanged)
	Q_PROPERTY(bool    conditionsMet READ isConditionsMet                 NOTIFY conditionsStateChagned)

public:
	Profile();
	explicit Profile(const QString &name, bool active = false);
	~Profile();

	inline QString name() const { return d->name; }
	void setName(const QString &name);

	inline bool isActive() const { return d->active; }
	void setActive(bool on);
	inline void activate() { setActive(true); }
	inline void deactivate() { setActive(false); }

	inline bool isConditionsMet() const { return d->doingActions; }

	inline Conditions conditions() const { return d->conditions; }
	inline Condition *condition(int index) const { return static_cast<Condition *>(d->conditions.at(index)); }

	void addCondition(Condition *condition);
	void removeCondition(Condition *condition);
	void removeCondition(int index);


	inline Actions actions() const { return d->actions; }
	inline Action *action(int index) const { return static_cast<Action *>(d->actions.at(index)); }

	void addAction(Action *action);
	void removeAction(Action *action);
	void removeAction(int index);

signals:
	void activeChanged();
	void nameChanged();
	void conditionsStateChagned();

private slots:
	void conditionStateChanged(bool state);

private:
	void init();
	void update();
	bool testConditions() const;
	void doActions() const;
	void stopActions() const;

	void updateNameChanged();
	void updateActiveChanged();

private:
	ProfileData *d;
};

/*************************************************************************************************/

#endif // PROFILE_H
