# -*- mode: makefile; coding: utf-8 -*-
# Copyright © 2007-2009 Instituto Nokia de Tecnologia - INdT
# Author: Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
# Description: Specific optimization CFLAGS for Maemo devices.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA.

_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class

ifndef _cdbs_rules_maemo_cflags
_cdbs_rules_maemo_cflags = 1

include $(_cdbs_rules_path)/buildvars.mk$(_cdbs_makefile_suffix)

ifeq ($(DEB_BUILD_ARCH),armel)
	COMMON_CFLAGS=-DNDEBUG=1 -fomit-frame-pointer -O2 -ffast-math -funsafe-math-optimizations -fno-math-errno -fsingle-precision-constant
	N770_CFLAGS=-mcpu=arm926ej-s
	N8x0_CFLAGS=-mfpu=vfp -mfloat-abi=softfp -mcpu=arm1136jf-s
	FREMANTLE_CFLAGS=-march=armv7-a -mtune=cortex-a8 -mfpu=neon -mfloat-abi=softfp
	#
	# Did someone tell us which device are we targeting?
	#
	ifneq ($(DEB_BUILD_OPTIONS),)
		ifneq (,$(findstring n770,$(DEB_BUILD_OPTIONS)))
			SPECIFIC_CFLAGS=$(N770_CFLAGS)
		endif
		ifneq (,$(findstring n8x0,$(DEB_BUILD_OPTIONS)))
			SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
		endif
		ifneq (,$(findstring n900,$(DEB_BUILD_OPTIONS)))
			SPECIFIC_CFLAGS=$(FREMANTLE_CFLAGS)
		endif
	endif
	#
	# Try the version file. May be /etc/osso_software_version or /etc/maemo_version
	#
	ifeq ($(SPECIFIC_CFLAGS),)
		VERSION_FILE=/etc/osso_software_version
		ifneq (0,$(shell test -e $(VERSION_FILE); echo $$?))
			VERSION_FILE=/etc/maemo_version
			ifneq (0,$(shell test -e $(VERSION_FILE); echo $$?))
				VERSION_FILE=
			endif
		endif
		ifneq ($(VERSION_FILE),)
			SW_VERSION?=$(shell cat $(VERSION_FILE)|tr "[:upper:]" "[:lower:]")
			ifneq (,$(findstring osso1.1,$(SW_VERSION)))
				SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
			endif
			ifneq (,$(findstring 2008se,$(SW_VERSION)))
				SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
			endif
			ifneq (,$(findstring diablo,$(SW_VERSION)))
				SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
			endif
			ifneq (,$(findstring fremantle,$(SW_VERSION)))
				SPECIFIC_CFLAGS=$(FREMANTLE_CFLAGS)
			endif
		endif
	endif
	#
	# sb-conf current may have the answer
	#
	ifeq ($(SPECIFIC_CFLAGS),)
		SB_CURRENT?=$(shell sb-conf current|tr "[:upper:]" "[:lower:]")
		ifneq (,$(findstring gregale,$(SB_CURRENT)))
			SPECIFIC_CFLAGS=$(N770_CFLAGS)
		endif
		ifneq (,$(findstring bora,$(SB_CURRENT)))
			SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
		endif
		ifneq (,$(findstring chinook,$(SB_CURRENT)))
			SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
		endif
		ifneq (,$(findstring diablo,$(SB_CURRENT)))
			SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
		endif
		ifneq (,$(findstring fremantle,$(SB_CURRENT)))
			SPECIFIC_CFLAGS=$(FREMANTLE_CFLAGS)
		endif
	endif
	#
	# No luck. reset everything
	#
	ifeq ($(SPECIFIC_CFLAGS),)
		COMMON_CFLAGS=
		SPECIFIC_CFLAGS=
	endif
endif

CFLAGS+=$(COMMON_CFLAGS) $(SPECIFIC_CFLAGS)
CXXFLAGS+=$(COMMON_CFLAGS) $(SPECIFIC_CFLAGS)

endif
