#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of maegirls.
#
# maegirls is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# maegirls is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with maegirls.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

from PyQt4.QtGui import *
from PyQt4.QtCore import *

import time

import algo

class DaysGraph(QWidget):
    def __init__(self, algo_, *args, **kwargs):
	QWidget.__init__(self, *args, **kwargs)

	self.min_day_width=20
	self.max_day_width=50
	self.day_width=50
	self.algo=algo_

	self.first_day=algo.today()

	self.last_x=None
	self.last_y=None

    def setAlgo(self, algo_):
	self.algo=algo_

    def reset(self):
	self.first_day=algo.today()
	self.update()

    def paintEvent(self, event):
	w0=self.width()
	h=self.height()

	gray=0x22

	days=int(w0/self.day_width)
	days=int((days)/2)*2 + 3
	w=days*self.day_width

	# Now calculate the x0
	x0=int((w0-w)/2)

	painter=QPainter(self)

	# This makes it sloooooooooooow
#	painter.setRenderHints(painter.Antialiasing \
#	    | painter.TextAntialiasing \
#	    | painter.HighQualityAntialiasing
#	    )

	# common day outline
	colol=QColor(0x66,0x66,0x66)
	penol=QPen(colol)

	# outline of the small block 
	colblockol=Qt.white
	penblockol=QPen(colblockol)

	# Current day outline
	colcur=Qt.white
	pencur=QPen(colcur, 3)

	# Text color
	coltxt=Qt.white
	pentxt=QPen(coltxt)

	# Font
	fontdate=QFont()
	fontdate.setPointSizeF(fontdate.pointSizeF()*0.5)
	fontdate_m=QFontMetrics(fontdate)

	# Last bounding rectagle of the text
	last_br=QRect(0,0,4,4)

	today=algo.today()

	for d in xrange(days):
	    # This will cause the first_day to be at the center
	    curday=self.first_day+d - int(days/2)
	    x=x0+d*self.day_width
	    y=0

	    h2=h-50

	    st=self.algo.status(curday)

	    if st['status']=='ok':
		colbg=QColor(gray, gray, gray)
		brbg=QBrush(colbg)

		painter.setPen(penol)
		painter.fillRect(x, y, self.day_width-1, h2-1, brbg) 
	    elif st['status']=='red' or \
		st['status']=='blue' or \
		st['status']=='green':
		if st['status']=='red':
		    perc=1.0*st['day'] / (st['len'])
		    colbg=QColor(
			0xff - int((0xff - gray - gray) * perc),
			int(gray * perc),
			int(gray * perc))
		    colblock=Qt.red
		elif st['status']=='blue':
		    perc=1.0*(st['day']+1) / (st['len'])
		    colbg=QColor(
			gray,
			gray,
			gray + ((0xff-gray) * perc))
		    colblock=Qt.blue
		elif st['status']=='green':
		    perc=1.0*(st['day']+1) / (st['len'])
		    colbg=QColor(
			gray,
			gray + ((0xff-gray) * perc),
			gray)
		    colblock=Qt.green
		brbg=QBrush(colbg)
		painter.fillRect(x, y, self.day_width-1, h2-1, brbg) 

		# Show a nice small box for interesting days
		boxw=20
		boxh=10

		# Ensure that boxw is sane - e.g. not larger than
		# the current day_width
		boxw2=self.day_width-10
		boxw=min(boxw, boxw2)

		x1=x+int((self.day_width-boxw)/2)

		if st['status']=='red':
		    y1=y + int(perc * h2*2/3) + 20
		elif st['status']=='blue' or st['status']=='green':
		    y1=y + int(h2*2/3) - int(perc * h2*2/3) + 20

		brbg=QBrush(colblock)
		painter.fillRect(x1, y1, boxw, boxh, brbg)
		painter.setPen(colblockol)
		painter.drawRect(x1, y1, boxw, boxh)

	    painter.setPen(colol)
	    painter.drawRect(x, y, self.day_width, h2-1)

	    # Highlight today
	    if curday==today:
		painter.setPen(pencur)
		painter.drawRect(x+2,y+2,self.day_width-4, h2-5)

	    date=time.localtime(curday*86400+30000)

	    y2=h2

	    txt="%d.%02d\n%d" % (date.tm_mday, date.tm_mon, date.tm_year)

	    # br is used to determine overlaps
	    br=fontdate_m.boundingRect(txt)
	    br.translate(x,y2)

	    colnum=1
	    while colnum*self.day_width < br.width():
		colnum+=2

	    # If this intersects with the previous day then it is ok
	    if br.intersects(last_br):
		continue
	    last_br=br

	    # br2 is the true bounding rectangle
	    # The width calculation helps with alignment
	    br2=QRect(x-((colnum-1)/2 * self.day_width), y2,
		self.day_width*colnum, fontdate_m.height()*2)

	    # Draw it
	    painter.setFont(fontdate)
	    painter.setPen(pentxt)
	    painter.drawText(br2, Qt.AlignCenter | Qt.AlignTop, txt)

    # Handle both horizontal and vertical movement
    def mouseMoveEvent(self, event):
	pos=event.pos()
	x=pos.x()
	y=pos.y()

	torepaint=False

	if self.last_x==None:
	    self.last_x=x
	    self.last_y=y

	# Vertical movement - that much pixels account for one zoom
	y_step=50

	# First look horizontal movement
	# If there was movement the reset vertical movement
	dx=x-self.last_x
	if dx>0:
	    days=int(dx/self.day_width)
	else:
	    days=-int(abs(dx)/self.day_width)

	if days!=0:
	    self.first_day-=days
	    self.last_x+=(days*self.day_width)
	    self.last_y=y	# Reset vertical movement
	    torepaint=True

	# Now look for vertical movement
	dy=y-self.last_y
	if dy>0:
	    zoom=int(dy/y_step)
	else:
	    zoom=-int(abs(dy)/y_step)

	if zoom!=0:
	    t=self.day_width+zoom
	    if t<self.min_day_width:
		t=self.min_day_width
	    elif t>self.max_day_width:
		t=self.max_day_width
	    #self.day_width-=zoom
	    self.day_width=t

	    self.last_y+=zoom*y_step
	    self.last_x=x	# Reset horizontal movement
	    torepaint=True
	
	if torepaint:
	    self.update()

    def mousePressEvent(self, event):
	pos=event.pos()
	self.last_x=pos.x()
	self.last_y=pos.y()

    def sizeHint(self):
	return(QSize(100,50))

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

