#ifndef FORMTODOLIST_H
#define FORMTODOLIST_H

#include <QWidget>
#include "tasklistmodel.h"
class FormTaskListNavigator;

namespace Ui {
    class FormTodoList;
}

class FormTodoList : public QWidget
{
    Q_OBJECT

public:
    explicit FormTodoList(QWidget *parent = 0);
    ~FormTodoList();

    void setSQLWhereClause(QString WhereClause);
    //void setSQLOrderClause(QString OrderClause);


public slots:
    void updateQuery();

private:
    Ui::FormTodoList *ui;
    TaskListModel *model;
    void DrawDelegates();

    QString SQLSelectClause;
    QString SQLWhereClause;
    QString SQLOrderClause;

    QString getQuery();

    FormTaskListNavigator* nav;
    void launchTaskEditor(int ComponentId);
    void drillDown(int FolderId);


private slots:
    void dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight);

    void on_treeView_activated(const QModelIndex &index);

};

#endif // FORMTODOLIST_H
