#include "calendarcomponentlistdelegate.h"

#include <QPainter>
#include <QStyleOptionViewItem>
#include <QModelIndex>
#include "taskviewfolderitem.h"

CalendarComponentListDelegate::CalendarComponentListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{

}

void CalendarComponentListDelegate::setComponent(int id, int type){

    delegateWidget = new CalendarComponentListWidget();
    delegateWidget->setComponentId(id);
    delegateWidget->setComponentType(type);
    delegateWidget->renderComponent();

}

void CalendarComponentListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {

    QStyledItemDelegate::paint(painter, option, index); //paint parent
    painter->save();
    //iw->resize(option.rect.size());
    painter->translate(option.rect.topLeft());
    //painter->drawText(0,0,"test");

    if(this->delegateWidget){

        delegateWidget->resize(option.rect.size());
        delegateWidget->render(painter,QPoint(),QRegion(), QWidget::DrawChildren);
    }
    //iw->render(painter,QPoint(),QRegion(), QWidget::DrawChildren); //autofill off so we get default paint effects below
    painter->restore();

}
