#include "taskviewtaskitem.h"
#include "ui_taskviewtaskitem.h"
#include <QPixmap>

TaskViewTaskItem::TaskViewTaskItem(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::TaskViewTaskItem)
{
    ui->setupUi(this);
}

TaskViewTaskItem::~TaskViewTaskItem()
{
    delete ui;
}

void TaskViewTaskItem::setSummary(QString Summary){
    ui->lblSummary->setText(Summary);
}

void TaskViewTaskItem::setDueDate(QDateTime DueDate){
    ui->lblDateDue->setText(DueDate.date().toString());
}

void TaskViewTaskItem::setCalendarIcon(QString IconPath){
    ui->lblCalendarIcon->setPixmap(QPixmap(IconPath));
}

void TaskViewTaskItem::setPriorityIcon(QString IconPath){
    ui->lblPriorityMeter->setPixmap(QPixmap(IconPath));
}

void TaskViewTaskItem::setUrgencyIcon(QString IconPath){
    ui->lblUrgency->setPixmap(QPixmap(IconPath));
}

void TaskViewTaskItem::setToggleAlarm(bool hasAlarm){
    ui->lblAlarmSet->setHidden(!hasAlarm);
}

void TaskViewTaskItem::setToggleAttachment(bool hasAttachment){
    ui->lblNotes->setHidden(!hasAttachment);
}
