#ifndef CALENDARCOMPONENTLISTWIDGET_H
#define CALENDARCOMPONENTLISTWIDGET_H

#include <QWidget>
#include "calendarcomponentlistrenderer.h"

//this widget will own the data and control the form

class QDateTime;

namespace Ui {
class CalendarComponentListWidget;
}

class CalendarComponentListWidget : public QWidget, CalendarComponentListRenderer
{
    Q_OBJECT
    
public:
    explicit CalendarComponentListWidget(QWidget *parent = 0);
    ~CalendarComponentListWidget();

    void setComponentId(int Id);
    int getComponentId();
    void setComponentType(int Type);
    int getComponentType();
    void renderComponent();


    
private:
    Ui::CalendarComponentListWidget *ui;
    int componentId;
    int componentType;
    void renderFolder();
    void renderTask();
    void renderNote();

    QString resolveCalendarIcon(int color) const;
    QString resolvePriorityIcon(int Priority) const;
    QString resolveUrgencyIcon(QDateTime DueDate) const;
};

#endif // CALENDARCOMPONENTLISTWIDGET_H
