#include "tasklistmodel.h"
#include <QtSql>
#include <iostream>
#include <QMap>

using namespace std;

TaskListModel::TaskListModel(QObject *parent) : QSqlQueryModel(parent){}

/*
  Column 0 is the checkable status column on the far left
  Column 1 will contain the ID in the table and should be set hidden if necessary
  */
QVariant  TaskListModel::data(const QModelIndex &item, int role) const {
    QVariant data = QSqlQueryModel::data(item,role); //process data from parent first

    if(role == Qt::DecorationRole && item.column() == 0){
        if(item.column() == 0){
            int component_type = item.sibling(item.row(),2).data().toInt();
            switch(component_type){
            case 0:
                //return QPixmap("/usr/share/icons/hicolor/48x48/hildon/general_folder.png");
                return QVariant();
            case 3:
                //return QPixmap("/usr/share/icons/hicolor/48x48/hildon/general_notes.png");
                return QVariant();
            }


        }
    }
    if(role == Qt::DisplayRole){
        if(item.column() == 0  )
            return QVariant();
    }

    if(role == Qt::CheckStateRole){
        switch(item.column()){
        case 0:
            if(item.data(Qt::EditRole).toInt() == 0 || item.data(Qt::EditRole).toInt() == 1) {
                //cout << "hi there" << item.data(Qt::EditRole).toInt() << endl;
                return item.data(Qt::EditRole).toBool() ? QVariant(Qt::Checked) : QVariant(Qt::Unchecked);
            }
            break;
        }
    }

    return data; //return default data from parent class
}

Qt::ItemFlags TaskListModel::flags(const QModelIndex &index) const{
    //cout << "flags index column:" << index.column() << endl;

    //cout << "flags" << index.data().toInt();
    //if(index.data() == 1 || index.data() == 0)

    Qt::ItemFlags flags = QSqlQueryModel::flags(index);
    if (index.column() == 0 )
        flags |=  Qt::ItemIsUserCheckable | Qt::ItemIsSelectable | Qt::ItemIsEnabled;
    return flags;

}

bool TaskListModel::setData(const QModelIndex &index, const QVariant &value, int role){
    debugFirstRow();
    cout << "setData called. value: " << value.toString().toLocal8Bit().constData() << "role:" << role << endl;
    if(index.column() == 0 && role == Qt::CheckStateRole){
        QVariant data = (value.toInt() == Qt::Checked) ? QVariant(1) : QVariant(0);
        int id = index.sibling(index.row(),1).data().toInt();
        //QModelIndex pk = index.sibling(index.row,0);

        cout << "Update:"  << setComplete(id, data.toInt()) << endl;
        //cout <<"setData DisplayRole:"<< QSqlQueryModel::setData(index,data.toInt(),Qt::DisplayRole) <<endl ;
        //QSqlQueryModel::setData(index,data.toInt());
        //QSqlQueryModel::setData(index,value,role);
        debugFirstRow();
        emit dataChanged(index, index);
        //setQuery("SELECT id,status,summary from components where componenttype=2");
        //setQuery(this->query());
        //cout << this->query().lastQuery().toLocal8Bit().constData() << endl;
        /*setQuery("SELECT id,status,'2',summary from components where componenttype=2 \
               // UNION SELECT id, status, '3', summary from components where componenttype=3");*/
        //setQuery(this->query().lastQuery()); //Should we do something elsewhere instead via the signal when the data gets changed?

    }
    if(index.column() == 0 && role == Qt::EditRole){

        cout << "edit role for column 0: "<< value.toInt() << endl;
    }
    return true;
}

bool TaskListModel::setComplete(int id, int status){
    QSqlQuery query;
    cout << "Updating status for id " << id << " to " << status << endl;
    query.prepare("update components set status=? where id=?");
    query.addBindValue(status);
    query.addBindValue(id);
    return query.exec();
}

void TaskListModel::debugFirstRow(){
    QMap<int, QVariant> dataRoles = this->itemData(this->index(3,0));

    QMapIterator<int, QVariant> i(dataRoles);
    while (i.hasNext()){
        i.next();
        cout << i.key() << ":" << i.value().toString().toLocal8Bit().constData() << endl;
    }

}
