#include "main.cpp"
#include "taskfolderitemdelegate.h"
#include "taskviewfolderitem.h"

#include <QPainter>
#include <QStyleOptionViewItem>
#include "folder.h"

/*
  The delegate will be used to store form-backing information and push it into the display widget/form
*/

TaskFolderItemDelegate::TaskFolderItemDelegate(QWidget *parent) : QStyledItemDelegate(parent), iw(new TaskViewFolderItem()){
    id = 0;
}
TaskFolderItemDelegate::~TaskFolderItemDelegate(){
    delete this->iw;
}

void TaskFolderItemDelegate::setId(int ComponentId){
    this->id = ComponentId;

    //load the class that represents the folder item.  this will cause lots of selects, but will optimize code later
    int error_code = 0;
    Folder* f = DB::getFolder(ComponentId, error_code);
    if (error_code == CALENDAR_OPERATION_SUCCESSFUL) {
        cout << "got the folder!" << endl;
        cout << "Folder name is:" << f->getName().toLocal8Bit().constData() << endl;
        iw->setFolderName(f->getName());
    }
    f = 0;
    delete f;   //folder pointer is just to get the data for displaying the form


}

void TaskFolderItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {

    QStyledItemDelegate::paint(painter, option, index); //paint parent
    painter->save();
    iw->resize(option.rect.size());
    painter->translate(option.rect.topLeft());
    iw->render(painter,QPoint(),QRegion(), QWidget::DrawChildren); //autofill off so we get default paint effects below
    painter->restore();

}
