#include "formtasklistnavigator.h"
#include "ui_formtasklistnavigator.h"
#include "taskeditor.h"
#include <QInputDialog>
#include "db.h"
#include <QMaemo5InformationBox>
#include "noteeditor.h"

#include <iostream>
using namespace std;

FormTaskListNavigator::FormTaskListNavigator(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::FormTaskListNavigator)
{
    ui->setupUi(this);
    this->folderId = 0; //invalid

}

FormTaskListNavigator::~FormTaskListNavigator()
{
    delete ui;
}

void FormTaskListNavigator::setSQLWhereClause(QString WhereClause){
    this->ui->taskList->setSQLWhereClause(WhereClause);
}

void FormTaskListNavigator::updateQuery(){
    this->ui->taskList->updateQuery();
}

void FormTaskListNavigator::hideNoteButton(bool hide){
    this->ui->buttonNote->setHidden(hide);
}

void FormTaskListNavigator::hideFolderButton(bool hide){
    this->ui->buttonFolder->setHidden(hide);
}

void FormTaskListNavigator::hideTaskButton(bool hide){
    this->ui->buttonTask->setHidden(hide);
}

void FormTaskListNavigator::setFolderId(int FolderId){
    this->folderId = FolderId;
    if(FolderId > 0){
        this->ui->buttonFolder->setHidden(false);
        this->ui->buttonNote->setHidden(false);
    }

    this->setWindowTitle(DB::getFolderName(this->folderId));
}

void FormTaskListNavigator::on_buttonTask_clicked()
{

    cout << "999999999999999999999 " << this->folderId << endl;
    TaskEditor e;
    if(this->folderId > 0) {

        e.addTask(folderId);
    } else {
        e.addTask();
    }
    this->ui->taskList->updateQuery();
}

void FormTaskListNavigator::on_buttonFolder_clicked()
{

    ///UGLY!

    bool ok = true;
    while (ok) //user is continuing to try to add
    {
        QString text = QInputDialog::getText(this,"Add Folder", "Folder Name",QLineEdit::Normal,"New Folder",&ok);
        if(ok && !text.isEmpty()){
            ok = DB::checkFolderExists(text,this->folderId);
            if(ok){
                QMaemo5InformationBox::information(this,"Folder already exists! Try again.");
            } else {
                ok = DB::createNewFolder(text, this->folderId);
                if(!ok){
                    QMaemo5InformationBox::information(this,"Failed to create folder!");
                } else {
                    ok = false;
                    this->ui->taskList->updateQuery();
                }
            }
        }
    }

}

void FormTaskListNavigator::on_buttonNote_clicked()
{
    cout << "999999999999999999999 " << this->folderId << endl;
    NoteEditor e;
    if(this->folderId > 0) {

        e.addJournal(folderId);
    } else {
        e.addJournal();
    }
    this->ui->taskList->updateQuery();
}
