#include "formfolderbrowser.h"
#include "ui_formfolderbrowser.h"
#include <QSqlQueryModel>
#include <QSqlQuery>

FormFolderBrowser::FormFolderBrowser(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::FormFolderBrowser)
{
    ui->setupUi(this);

    this->parentLevel = 0;
    this->stackIds.push_front(0);
    this->stackNames.push_front("/");


    this->ui->lblLevel->setHidden(true);

    model = new QSqlQueryModel(this);
    //model->setQuery("SELECT FolderId, Summary FROM Folder");
    loadLevel();
    ui->listFolders->setModel(model);
    ui->listFolders->setModelColumn(1);


}

FormFolderBrowser::~FormFolderBrowser()
{
    delete ui;
}

void FormFolderBrowser::loadLevel() {

    this->ui->lblLevel->setText(QString::number(this->stackIds.last()));

    QSqlQuery q;
    q.prepare("SELECT FolderId, Summary FROM Folder WHERE Parent=?");
    q.addBindValue(this->stackIds.last());
    q.exec();
    this->model->setQuery(q);

    if(this->stackIds.last() == 0) {
        this->ui->buttonSelectFolder->setDisabled(true);
        this->ui->buttonUp->setDisabled(true);
    } else {
        this->ui->buttonSelectFolder->setDisabled(false);
        this->ui->buttonUp->setDisabled(false);
    }
    this->ui->buttonSelectFolder->setText(this->stackNames.last());
}

void FormFolderBrowser::on_listFolders_activated(const QModelIndex &index)
{
    this->stackIds.push_back(index.sibling(index.row(),0).data().toInt());
    this->stackNames.push_back(index.data().toString());
    loadLevel();
}


void FormFolderBrowser::on_buttonUp_clicked()
{
    this->stackIds.pop_back();
    this->stackNames.pop_back();

    loadLevel();

}

int FormFolderBrowser::getSelectedFolderId(){
    return this->stackIds.last();
}

void FormFolderBrowser::on_buttonSelectFolder_clicked()
{
    emit folderSelected(this->stackIds.last(), this->stackNames.last());
}

void FormFolderBrowser::on_buttonInbox_clicked()
{
    emit folderSelected(-1, "Inbox");
}
