#include "dialogcalendarlist.h"
#include "ui_dialogcalendarlist.h"
#include <QSqlQueryModel>
#include "calendarlistmodel.h"
#include "calendarlistitemdelegate.h"
#include <iostream>
#include <QMaemo5AbstractPickSelector>

using namespace std;

DialogCalendarList::DialogCalendarList(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogCalendarList)
{
    ui->setupUi(this);

    this->picker = 0;

    QSqlQueryModel *model = new CalendarListModel;
    model->setQuery("select calendarid, name, colour, ' ' delegate, calendartype from calendars");

    //cout << "MODEL COLUMN COUNT: " << model->columnCount() << endl;
    ui->listView->setModel(model);
    ui->listView->setModelColumn(3); //empty string hack for delegate painting
    ui->listView->setItemDelegate(new CalendarListItemDelegate());
}

DialogCalendarList::~DialogCalendarList()
{
    delete ui;
}


void DialogCalendarList::on_listView_activated(const QModelIndex &index)
{
    this->calendarId = index.sibling(index.row(),0).data().toInt();
    this->calendarName = index.sibling(index.row(),1).data().toString();
    this->calendarType = index.sibling(index.row(),4).data().toString();

    cout << "calendar id is:" << this->calendarId << endl;
    cout << "calendar name is:" << this->calendarName.toLocal8Bit().constData() << endl;
    cout << "calendar type is:" << this->calendarType.toLocal8Bit().constData() << endl;

    emit calendarIdChanged(this->calendarId);
    QString displayText = calendarName.append(" ").append(calendarType);
    emit calendarTextChanged(displayText);
    emit selected(displayText);
    this->hide();
}

int DialogCalendarList::getCalendarId(){
    return this->calendarId;
}

QString DialogCalendarList::getCalendarName(){
    return this->calendarName;
}

QString DialogCalendarList::getCalendarType(){
    return this->calendarType;
}

void DialogCalendarList::setPicker(QMaemo5AbstractPickSelector *picker){
    this->picker = picker;
}
