#ifndef DATABASE_H
#define DATABASE_H

#include <QSqlDatabase>
#include <QSqlQuery>
#include <QDir>
#include <QFile>
#include <QStringList>

const QString DB_HOME = QDir::homePath() + "/.calendar/calendardb";

/*query strings*/
// TODO - externalize these later

//DDL

        const QString DDL_FOLDER = "\
        CREATE TABLE Folder ( \
            FolderId INTEGER PRIMARY KEY AUTOINCREMENT, \
            Parent INTEGER,Sequence INTEGER,Summary TEXT)";

        const QString DDL_FOLDER_ITEM = "\
        CREATE TABLE FolderItem ( \
            FolderId INTEGER, \
            Id INTEGER)";

        const QString DDL_SETTING = "\
        CREATE TABLE Setting ( \
            SettingKey TEXT PRIMARY KEY, \
            SettingValue TEXT)";

        const QString DDL_TASK = "\
        CREATE TABLE Task ( \
            Id INTEGER, \
            FolderId)";

        const QString DDL_NOTE = "\
        CREATE TABLE Note ( \
            Id INTEGER, \
            FolderId)";

//DML
const QStringList DML_GROUPS = (QStringList() <<
    "INSERT INTO Folder (Parent, Sequence, Summary) VALUES (0,1,'Projects')" <<
    "INSERT INTO Folder (Parent, Sequence, Summary) VALUES (0,2,'Lists')" <<
    "INSERT INTO Folder (Parent, Sequence, Summary) VALUES (0,3,'Someday')");


const QString DML_GROUP_LIST="Select FolderID, Summary FROM Folder WHERE Parent=0 ORDER BY Sequence";
/* end query strings*/

bool db_connect();
bool db_create();
void db_sync();
int db_getInbox();
void check_tables();

bool create_table_setting();
bool create_table_folder();
bool create_table_folder_item();
bool create_table_task();
bool create_table_note();


#endif // DATABASE_H
